<?php
/************************************************************
~ AUTOR Andreas Theusner  2003
~  - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: Menmodul fr AT Contenator
~ DATEI: module.Sitemap._blank.php
~ ZWECK: erzeugt eine Sitemap fr eine AT-Contenator-Website
~ BEMERKUNGEN:
~   Aufgrund der Besonderheiten bei der Mengenerierung des
~   Contenators wurde hier auf eine rekursive Generierung
~   der Verzeichnisse als Sitmap verzichtet. Stattdessen
~   wurde hier direkt addressiert (Hardcore-Programmierung).
~   D.h. es wurde von Hand geschachtelt. Eine Sitemap kann
~   bis zu einer Tiefe von max. 10 Untermens generiert werden.
~   Wer es noch mehr mag, der kann die Verschachtelung per
~   Hand bis zu beliebiger Gre weiterfhren.
~   Sollte das jemand tun wollen, so mu er die absoluten
~   Pfadangaben (deren Inhalte aber variabel sind und von
~   den Verzeichnisnamen abhngen) weiternummerieren. Wichtig
~   ist der Inhalt der Variable $level, weil jede index.php
~   in den Verzeichnissen diese bentigt, um den Pfad zum
~   Parser im Root (Mitgabe per Variable $parser) automatisch
~   zu generieren.
~   Die Ausgabe der Verzeichnisse im entsprechenden Baum in
~   der Sitemap erfolgt unsortiert. Das ist leider eine
~   Einschrnkung der genutzten PHP-Funktion readdir().
~************************************************************

~************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
~************************************************************
~ FUNKTIONSWEISE
~	--------------
~	Es werden Verzeichnisse als Links generiert und in einem
~	Men angeordnet. Enthlt ein Link ein Untermen (sprich
~	Unterverzeichnis), klappt der Link mit einem Untermen
~ im Explorerstil nach unten und eingerckt aus.
~
~ VORAUSSETZUNGEN FR Die FUNKTIONALITT DES LINKGENERATORS
~	---------------------------------------------------------
~	- ein einstelliger numerischer Wert vor dem Verzeichnisname
~		in folgendem Format: 1_Verzeichnisname (Unterstrich ist
~		notwendig); hier kann der erste Buchstabe gro oder klein
~		geschrieben werden; der numerische Wert dient als
~		Sortierungskriterium fr das Verzeichnis
~
~	- ist kein numerischer Wert vorhanden, dann wird das
~		Verzeichnis nur angezeigt, wenn der erste Buchstabe
~		gro geschrieben ist; ist er klein geschrieben, wird
~		das Verzeichnis nicht als Link im Men angezeigt;
~   hier dient der Anfangsbuchstabe als Sortierkriterium
~
~	- damit ein Verzeichnis als Link generiert werden kann,
~		mu sich in diesem mindestens eine Datei mit folgendem
~		Namen befinden: index.php
~
~ - HINWEIS:
~   Die index.php fr den Verzeichniszugriff ist nicht identisch
~   mit der index.php im Root (Verzeichniswurzel) der Website!
~   Diese index.php enthlt den Parser fr content.txt.
~
~	- damit ein Men auch dann automatisch zuklappt, wenn
~		ein anderer Menpunkt kein Untermen hat, sollte
~		unter diesen Menpunkt ein Dummy-Verzeichnis als Zahl
~		(z.B. 1 oder 1_) angelegt und dort eine index.php
~		hineinkopiert werden
~
~ - Verzeichnisnamen, Die als Men generiert werden sollen,
~   drfen keine Sonderzeichen und Umlaute wie , , , 
~   enthalten
~
~ SYSTEME
~ -------
~ Die Lauffhigkeit wurde erfolgreich unter Linux und Windows
~ jeweils mit verschiedenen Apache- und php-Versionen
~ erfolgreich getestet.
~
~ BROWSER
~ -------
~ Erfolgreich getestet im Internet Explorer ab Version 4,
~ Netscape ab Version 4.7x und Opera ab Version 6.xx
~
~ HINWEISE
~ --------
~ detailliertere Kommentare sind im Quelltext zu finden
************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

$parser = "core.parser.php"; //PARSERDATEI
$baumcolor = "red";          //FARBE FR DIE BAUMSTRUKTUR - IST KEINE FARBE ZUGEORDNET, WIRD DIE STANDARDFARBE FR DEN BODY GENOMMEN
/*****************************************************************************************
~ NAME: function sitmap_generate ($dir)
~ ART: php-Script
~ ZWECK: untersucht, ob Verzeichnisse und gibt sie als Sitmap-Links aus
~ AUFRUF: sitmap_generate($dir)   -> BSP: sitmap_generate(".");
~
*****************************************************************************************/
function sitmap_generate($dir)
{
  global $parser;
  global $baumcolor;
  
  //---OBERVERZEICHNIS DURCHLAUFEN - ANFANG-----------------------
  $verzeichnis=@opendir ($dir);

  while ($verz = @readdir ($verzeichnis))  //WHILE OBERVERZEICHNIS - ANFANG
  {
    if((is_dir("$dir/$verz") && !is_file($verz))  && ($verz != "." && $verz != "..") && substr($verz,0,1) != "_" && substr($verz,0,2) != "__" && substr($verz,0,18) != "3_Download-Bereich")  //IF OBERVERZEICHNIS - ANFANG
    {
       if(substr($verz,0,1) != "1") $linkname = substr($verz,1,1) == "_" ? substr($verz,2,strlen($verz)-2) : substr($verz,0,strlen($verz));  //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
       if(substr($verz,0,1) == "1" && substr($verz,1,1) == "_") $linkname = substr($verz,1,1) == "_" ? substr($verz,2,strlen($verz)-2) : substr($verz,0,strlen($verz)); //AUCH ORDNER MIT 1_ ANZEIGEN ABER NICHT ORDNER DIE 1 HEISSEN -> AUF/ZUKLAPP-EFFEKT
       if(isset($linkname)) 
       {
       	 echo "<font color=\"$baumcolor\">&raquo;</font><a href=\"$dir/$verz/index.php?level=0&includeseite=$parser\"><b>&nbsp;$linkname&nbsp;</b></a><br>\n";  //VERZEICHNIS ALS LINK AUSGEBEN
         unset($linkname);
       }
       
       //----UNTERVERZEICHNIS 1 DURCHLAUFEN - ANFANG-----------------------
       $unterverzeichnis1=@opendir ("$dir/$verz");

       while ($uverz1 = @readdir ($unterverzeichnis1))  //WHILE UNTERVERZEICHNIS 1 - ANFANG
       {
         if((is_dir("$dir/$verz/$uverz1") && !is_file($uverz1))  && ($uverz1 != "." && $uverz1 != "..") && substr($uverz1,0,1) != "_" && substr($uverz1,0,2) != "__") //IF UNTERVERZEICHNIS 1 - ANFANG
         {
            if(substr($uverz1,0,1) != "1") $linkname1 = substr($uverz1,1,1) == "_" ? substr($uverz1,2,strlen($uverz1)-2) : substr($uverz1,0,strlen($uverz1)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
            if(substr($uverz1,0,1) == "1" && substr($uverz1,1,1) == "_") $linkname1 = substr($uverz1,1,1) == "_" ? substr($uverz1,2,strlen($uverz1)-2) : substr($uverz1,0,strlen($uverz1));
            if(isset($linkname1)) 
            { 
            	for($i=0;$i<=7;$i++) { if($i==4) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }  //IN 4er SCHRITTE BAUMSTRUKTURELEMENT EINFGEN - $i MU BIS MAX. LETZTER ZAHLWERT + 3 LAUFEN (HIER 4 + 3)
            	echo "&brvbar;-</font><a href=\"$dir/$verz/$uverz1/index.php?level=1&includeseite=$parser\"><b>&nbsp;$linkname1&nbsp;</b></a><br>\n";  //VERZEICHNIS ALS LINK AUSGEBEN
              unset($linkname1);
            }
            
            //----UNTERVERZEICHNIS 2 DURCHLAUFEN - ANFANG-----------------------
            $unterverzeichnis2=@opendir ("$dir/$verz/$uverz1");

            while ($uverz2 = @readdir ($unterverzeichnis2))  //WHILE UNTERVERZEICHNIS 2 - ANFANG
            {
              if((is_dir("$dir/$verz/$uverz1/$uverz2") && !is_file($uverz2))  && ($uverz2 != "." && $uverz2 != "..") && substr($uverz2,0,1) != "_" && substr($uverz2,0,2) != "__") //IF UNTERVERZEICHNIS 2 - ANFANG
              {
                if(substr($uverz2,0,1) != "1") $linkname2 = substr($uverz2,1,1) == "_" ? substr($uverz2,2,strlen($uverz2)-2) : substr($uverz2,0,strlen($uverz2)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
                if(substr($uverz2,0,1) == "1" && substr($uverz2,1,1) == "_") $linkname2 = substr($uverz2,1,1) == "_" ? substr($uverz2,2,strlen($uverz2)-2) : substr($uverz2,0,strlen($uverz2));
                if(isset($linkname2)) 
                { 
                	for($i=0;$i<=15;$i++) { if($i==4 || $i==8 || $i==12) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
                	echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/index.php?level=2&includeseite=$parser\"><b>&nbsp;$linkname2&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
              	  unset($linkname2);
                }
                
                //----UNTERVERZEICHNIS 3 DURCHLAUFEN - ANFANG-----------------------
		            $unterverzeichnis3=@opendir ("$dir/$verz/$uverz1/$uverz2");
		
		            while ($uverz3 = @readdir ($unterverzeichnis3))  //WHILE UNTERVERZEICHNIS 3 - ANFANG
		            {
		              if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3") && !is_file($uverz3))  && ($uverz3 != "." && $uverz3 != "..") && substr($uverz3,0,1) != "_" && substr($uverz3,0,2) != "__") //IF UNTERVERZEICHNIS 3 - ANFANG
		              {
		                if(substr($uverz3,0,1) != "1") $linkname3 = substr($uverz3,1,1) == "_" ? substr($uverz3,2,strlen($uverz3)-2) : substr($uverz3,0,strlen($uverz3)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
		                if(substr($uverz3,0,1) == "1" && substr($uverz3,1,1) == "_") $linkname3 = substr($uverz3,1,1) == "_" ? substr($uverz3,2,strlen($uverz3)-2) : substr($uverz3,0,strlen($uverz3));
		                if(isset($linkname3)) 
		                { 
		                	for($i=0;$i<=23;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
		                	echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/index.php?level=3&includeseite=$parser\"><b>&nbsp;$linkname3&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
		              	  unset($linkname3);
		                }
		                
		                //----UNTERVERZEICHNIS 4 DURCHLAUFEN - ANFANG-----------------------
				            $unterverzeichnis4=@opendir ("$dir/$verz/$uverz1/$uverz2/$uverz3");
				
				            while ($uverz4 = @readdir ($unterverzeichnis4))  //WHILE UNTERVERZEICHNIS 4 - ANFANG
				            {
				              if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4") && !is_file($uverz4))  && ($uverz4 != "." && $uverz4 != "..") && substr($uverz4,0,1) != "_" && substr($uverz4,0,2) != "__") //IF UNTERVERZEICHNIS 4 - ANFANG
				              {
				                if(substr($uverz4,0,1) != "1") $linkname4 = substr($uverz4,1,1) == "_" ? substr($uverz4,2,strlen($uverz4)-2) : substr($uverz4,0,strlen($uverz4)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
				                if(substr($uverz4,0,1) == "1" && substr($uverz4,1,1) == "_") $linkname4 = substr($uverz4,1,1) == "_" ? substr($uverz4,2,strlen($uverz4)-2) : substr($uverz4,0,strlen($uverz4));
				                if(isset($linkname4)) 
				                { 
				                	for($i=0;$i<=31;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20 || $i==24 || $i==28) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
				                	echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/index.php?level=4&includeseite=$parser\"><b>&nbsp;$linkname4&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
				              	  unset($linkname4);
				                }
				                
				                //----UNTERVERZEICHNIS 5 DURCHLAUFEN - ANFANG-----------------------
						            $unterverzeichnis5=@opendir ("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4");
						
						            while ($uverz5 = @readdir ($unterverzeichnis5))  //WHILE UNTERVERZEICHNIS 5 - ANFANG
						            {
						              if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5") && !is_file($uverz5))  && ($uverz5 != "." && $uverz5 != "..") && substr($uverz5,0,1) != "_" && substr($uverz5,0,2) != "__") //IF UNTERVERZEICHNIS 5 - ANFANG
						              {
						                if(substr($uverz5,0,1) != "1") $linkname5 = substr($uverz5,1,1) == "_" ? substr($uverz5,2,strlen($uverz5)-2) : substr($uverz5,0,strlen($uverz5)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
						                if(substr($uverz5,0,1) == "1" && substr($uverz5,1,1) == "_") $linkname5 = substr($uverz5,1,1) == "_" ? substr($uverz5,2,strlen($uverz5)-2) : substr($uverz5,0,strlen($uverz5));
						                if(isset($linkname5)) 
						                { 
						                	for($i=0;$i<=39;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20 || $i==24 || $i==28 || $i==32 || $i==36) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
						                	echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/index.php?level=5&includeseite=$parser\"><b>&nbsp;$linkname5&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
						              	  unset($linkname5);
						                }
						                
						                //----UNTERVERZEICHNIS 6 DURCHLAUFEN - ANFANG-----------------------
								            $unterverzeichnis6=@opendir ("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5");
								
								            while ($uverz6 = @readdir ($unterverzeichnis6))  //WHILE UNTERVERZEICHNIS 6 - ANFANG
								            {
								              if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6") && !is_file($uverz6))  && ($uverz6 != "." && $uverz6 != "..") && substr($uverz6,0,1) != "_" && substr($uverz6,0,2) != "__") //IF UNTERVERZEICHNIS 6 - ANFANG
								              {
								                if(substr($uverz6,0,1) != "1") $linkname6 = substr($uverz6,1,1) == "_" ? substr($uverz6,2,strlen($uverz6)-2) : substr($uverz6,0,strlen($uverz6)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
								                if(substr($uverz6,0,1) == "1" && substr($uverz6,1,1) == "_") $linkname6 = substr($uverz6,1,1) == "_" ? substr($uverz6,2,strlen($uverz6)-2) : substr($uverz6,0,strlen($uverz6));
								                if(isset($linkname6)) 
								                { 
								                	for($i=0;$i<=43;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20 || $i==24 || $i==28 || $i==32 || $i==36 || $i==40) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
								                	echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/index.php?level=6&includeseite=$parser\"><b>&nbsp;$linkname6&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
								              	  unset($linkname6);
								                }
								                
								                //----UNTERVERZEICHNIS 7 DURCHLAUFEN - ANFANG-----------------------
								                $unterverzeichnis7=@opendir ("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6");
								
								                while ($uverz7 = @readdir ($unterverzeichnis7))  //WHILE UNTERVERZEICHNIS 6 - ANFANG
								                {
								                  if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7") && !is_file($uverz7))  && ($uverz7 != "." && $uverz7 != "..") && substr($uverz7,0,1) != "_" && substr($uverz7,0,2) != "__") //IF UNTERVERZEICHNIS 7 - ANFANG
								                  {
								                    if(substr($uverz7,0,1) != "1") $linkname7 = substr($uverz7,1,1) == "_" ? substr($uverz7,2,strlen($uverz7)-2) : substr($uverz7,0,strlen($uverz7)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
								                    if(substr($uverz7,0,1) == "1" && substr($uverz7,1,1) == "_") $linkname7 = substr($uverz7,1,1) == "_" ? substr($uverz7,2,strlen($uverz7)-2) : substr($uverz7,0,strlen($uverz7));
								                    if(isset($linkname7))
								                    {
								                	    for($i=0;$i<=47;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20 || $i==24 || $i==28 || $i==32 || $i==36 || $i==40 || $i==44) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
								                	    echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/index.php?level=7&includeseite=$parser\"><b>&nbsp;$linkname7&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
								              	      unset($linkname7);
								                    }
								                    
								                    //----UNTERVERZEICHNIS 8 DURCHLAUFEN - ANFANG-----------------------
								                    $unterverzeichnis8=@opendir ("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7");
								
								                    while ($uverz8 = @readdir ($unterverzeichnis8))  //WHILE UNTERVERZEICHNIS 6 - ANFANG
								                    {
								                      if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8") && !is_file($uverz8))  && ($uverz8 != "." && $uverz8 != "..") && substr($uverz8,0,1) != "_" && substr($uverz8,0,2) != "__") //IF UNTERVERZEICHNIS 8 - ANFANG
								                      {
								                        if(substr($uverz8,0,1) != "1") $linkname8 = substr($uverz8,1,1) == "_" ? substr($uverz8,2,strlen($uverz8)-2) : substr($uverz8,0,strlen($uverz8)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
								                        if(substr($uverz8,0,1) == "1" && substr($uverz8,1,1) == "_") $linkname8 = substr($uverz8,1,1) == "_" ? substr($uverz8,2,strlen($uverz8)-2) : substr($uverz8,0,strlen($uverz8));
								                        if(isset($linkname8))
								                        {
								                	        for($i=0;$i<=51;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20 || $i==24 || $i==28 || $i==32 || $i==36 || $i==40 || $i==44 || $i==48) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
								                	        echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8/index.php?level=8&includeseite=$parser\"><b>&nbsp;$linkname8&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
								              	          unset($linkname8);
								                        }
								                        
								                        //----UNTERVERZEICHNIS 9 DURCHLAUFEN - ANFANG-----------------------
								                        $unterverzeichnis9=@opendir ("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8");
								
								                        while ($uverz9 = @readdir ($unterverzeichnis9))  //WHILE UNTERVERZEICHNIS 6 - ANFANG
								                        {
								                          if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8/$uverz9") && !is_file($uverz9))  && ($uverz9 != "." && $uverz9 != "..") && substr($uverz9,0,1) != "_" && substr($uverz9,0,2) != "__") //IF UNTERVERZEICHNIS 9 - ANFANG
								                          {
								                            if(substr($uverz9,0,1) != "1") $linkname9 = substr($uverz9,1,1) == "_" ? substr($uverz9,2,strlen($uverz9)-2) : substr($uverz9,0,strlen($uverz9)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
								                            if(substr($uverz9,0,1) == "1" && substr($uverz9,1,1) == "_") $linkname9 = substr($uverz9,1,1) == "_" ? substr($uverz9,2,strlen($uverz9)-2) : substr($uverz9,0,strlen($uverz9));
								                            if(isset($linkname9))
								                            {
								                	            for($i=0;$i<=55;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20 || $i==24 || $i==28 || $i==32 || $i==36 || $i==40 || $i==44 || $i==48 || $i==52) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
								                	            echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8/$uverz9/index.php?level=9&includeseite=$parser\"><b>&nbsp;$linkname9&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
								              	              unset($linkname9);
								                            }
								                            
								                            //----UNTERVERZEICHNIS 10 DURCHLAUFEN - ANFANG-----------------------
								                            $unterverzeichnis10=@opendir ("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8/$uverz9");
								
								                            while ($uverz10 = @readdir ($unterverzeichnis10))  //WHILE UNTERVERZEICHNIS 6 - ANFANG
								                            {
								                              if((is_dir("$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8/$uverz9/$uverz10") && !is_file($uverz10))  && ($uverz10 != "." && $uverz10 != "..") && substr($uverz10,0,1) != "_" && substr($uverz10,0,2) != "__") //IF UNTERVERZEICHNIS 10 - ANFANG
								                              {
								                                if(substr($uverz10,0,1) != "1") $linkname10 = substr($uverz10,1,1) == "_" ? substr($uverz10,2,strlen($uverz10)-2) : substr($uverz10,0,strlen($uverz10)); //AUF _ UNTERSUCHEN BEI VORANGESTELLTER ZAHL
								                                if(substr($uverz10,0,1) == "1" && substr($uverz10,1,1) == "_") $linkname10 = substr($uverz10,1,1) == "_" ? substr($uverz10,2,strlen($uverz10)-2) : substr($uverz10,0,strlen($uverz10));
								                                if(isset($linkname10))
								                                {
								                	                for($i=0;$i<=59;$i++) { if($i==4 || $i==8 || $i==12 || $i==16 || $i==20 || $i==24 || $i==28 || $i==32 || $i==36 || $i==40 || $i==44 || $i==48 || $i==52 || $i==56) echo "<font color=\"$baumcolor\">&brvbar;"; else echo "&nbsp;"; }
								                	                echo "<font color=\"$baumcolor\">&brvbar;-</font><a href=\"$dir/$verz/$uverz1/$uverz2/$uverz3/$uverz4/$uverz5/$uverz6/$uverz7/$uverz8/$uverz9/$uverz10/index.php?level=10&includeseite=$parser\"><b>&nbsp;$linkname10&nbsp;</b></a><br>\n"; //VERZEICHNIS ALS LINK AUSGEBEN
								              	                  unset($linkname10);
								                                }
                                              } //IF UNTERVERZEICHNIS 10 - ENDE
								                            } //WHILE UNTERVERZEICHNIS 10 - ENDE
								                            @closedir($unterverzeichnis10);
								                            //----UNTERVERZEICHNIS 10 DURCHLAUFEN - ENDE-----------------------
								                            
                                          } //IF UNTERVERZEICHNIS 9 - ENDE
								                        } //WHILE UNTERVERZEICHNIS 9 - ENDE
								                        @closedir($unterverzeichnis8);
								                        //----UNTERVERZEICHNIS 9 DURCHLAUFEN - ENDE-----------------------
								                        
								         			        } //IF UNTERVERZEICHNIS 8 - ENDE
								                    } //WHILE UNTERVERZEICHNIS 8 - ENDE
								                    @closedir($unterverzeichnis8);
								                    //----UNTERVERZEICHNIS 8 DURCHLAUFEN - ENDE-----------------------
								                    
								         			    } //IF UNTERVERZEICHNIS 7 - ENDE
								                } //WHILE UNTERVERZEICHNIS 7 - ENDE
								                @closedir($unterverzeichnis7);
								                //----UNTERVERZEICHNIS 7 DURCHLAUFEN - ENDE-----------------------
								                
								         			} //IF UNTERVERZEICHNIS 6 - ENDE
								            } //WHILE UNTERVERZEICHNIS 6 - ENDE
								            @closedir($unterverzeichnis6);
								            //----UNTERVERZEICHNIS 6 DURCHLAUFEN - ENDE-----------------------
						                
						         			} //IF UNTERVERZEICHNIS 5 - ENDE
						            } //WHILE UNTERVERZEICHNIS 5 - ENDE
						            @closedir($unterverzeichnis5);
						            //----UNTERVERZEICHNIS 5 DURCHLAUFEN - ENDE-----------------------
				                
				         			} //IF UNTERVERZEICHNIS 4 - ENDE
				            } //WHILE UNTERVERZEICHNIS 4 - ENDE
				            @closedir($unterverzeichnis4);
				            //----UNTERVERZEICHNIS 4 DURCHLAUFEN - ENDE-----------------------
		                
		         			} //IF UNTERVERZEICHNIS 3 - ENDE
		            } //WHILE UNTERVERZEICHNIS 3 - ENDE
		            @closedir($unterverzeichnis3);
		            //----UNTERVERZEICHNIS 3 DURCHLAUFEN - ENDE-----------------------
                
         			} //IF UNTERVERZEICHNIS 2 - ENDE
            } //WHILE UNTERVERZEICHNIS 2 - ENDE
            @closedir($unterverzeichnis2);
            //----UNTERVERZEICHNIS 2 DURCHLAUFEN - ENDE-----------------------
            
         } //IF UNTERVERZEICHNIS 1 - ENDE
       } //WHILE UNTERVERZEICHNIS 1 - ENDE
       @closedir($unterverzeichnis1);
       //----UNTERVERZEICHNIS 1 DURCHLAUFEN - ENDE-----------------------
       
       echo "<hr width=\"100%\" size=\"1\" noshade>";
       
    } //IF OBERVERZEICHNIS - ENDE
  } //WHILE OBERVERZEICHNIS - ENDE

  @closedir($verzeichnis);
  //---OBERVERZEICHNIS DURCHLAUFEN - ENDE-----------------------
}


/*######################################################################################
~ HAUPTPROGRAMM
######################################################################################*/
include_once("core.config.php");

$stylepfad = config_read("stylepfad",$pfad."_config");  //KONFIGURATION FR STYLE HOLEN
$stylepfad = chop($stylepfad);

echo <<< KOPF
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
 <html>
 	<head>
 		<title>AT Contenator - Sitemap</title>
 		<Link rel="stylesheet" type="text/css" href="$stylepfad/verzeichnis.index.css">
 		<meta name="Generator" content="AT Contenator">
    <meta http-equiv="expires" content="0">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
 	</head>
<body>
<center><h3>Sitemap</h3><hr width="100%" size="1" noshade></center>
KOPF;

sitmap_generate(".");

echo <<< FUSS
</body>
</html>
FUSS;
?>
