<?php
/**********************************************************************************************
~ AUTOR: Andreas Theusner,  2003 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator
~ DATEI: modul.parser.thumbnails.php
~ ZWECK: Parser-Modul fr Thumbnails
~ FUNKTIONSWEISE: skaliert und generiert alle nach einen bestimmten Muster (string im Dateinamen)
~                 aufgebauten Grafikdateien als Thumbnails mit gleichzeitiger Verlinkung
~                 zur Ansicht der Originalgre in einem separaten Fenster
~ BEMERKUNG FR DEN EINSATZ:
~  In Zeile 85 wird das Modul angewiesen, nur Dateien als Thumbnails zu generieren, in deren Namen
~  "voll" oder "thumb" enthalten ist z.B. bild_thumb.gif oder bild_voll.png. Das ist deshalb
~  notwendig, damit nur die gewnschten Bilder als Thumbnails generiert werden und nicht alle Bilder
~  in allen Verzeichnissen, denn Parser-Module wirken global. Diese Zeile kann beliebige erweitert
~  werden. Auch sollte in der "core.config.dat" im Verzeichnis "_config" der Eintrag "parsermodule=on"
~  lauten. Ebenfalls in dieser Datei kann die Anzahl der Thumbnails, die in einer Reihe dargestellt
~  werden sollen unter dem Eintrag "thumbnails" verndert werden.
/**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

/* //EINFACHE VARIANTE - RESOURCENSPARENDER, WEIL NUR KLEINE BILDER ANGEZIGT WERDEN
   //UND AUF DIE GROEN VERLINKT WIRD
  $dir=opendir (".");											//RELATIVES VERZEICHNIS IN $pfad FFNEN

  echo "<center>";

  while ($datei = readdir ($dir)) 						//JEDEN EINTRAG LESEN
  {
		if(is_file($datei) && preg_match("/thumb/",$datei) && preg_match("/.gif/",$datei)) //NUR WENN $file EINE DATEI IST UND "matcht" IST
		{
		  $counter++;       //ZHLER FR DURCHLUFE
		  if($counter > 3 )   //WENN WERT HHER IST, DANN
      {
        echo "<p>";     //NEUE REIHE
        $counter=0;     //ZHLER AUF 0
      }

      //LINK GENERIEREN - FR VOLLBILD BEZEICHNUNG AUSTAUSCHEN
			echo "<a href=\"" . str_replace("thumb","voll",$datei) ."\" target=\"_blank\"><img src=\"$datei\" border=\"1\"></a>&nbsp;&nbsp;\n";
			
		}
  }

  closedir($dir);                        //VERZEICHNIS SCHLIEEN
  */
//------------------------------------------------------------------------
//FLEXIBLERE VARIANTE  - RESSOURCENINTENSIVER, WEIL ALLE BILDER ZWAR SKALIERT,
//ABER AUCH DURCH DIE LEITUNG "DURCHGEZOGEN" WERDEN

//CSS-STYLE FR TABELLE DEFINIEREN, DER DEN ZENTRALE STYLE IN DER core.verzeichnis.css BERSCHREIBT
  echo "<style type=\"text/css\">";
  echo "<!--";
  echo "table.thumb {font-family: Tahoma, Arial, Helvetica; background: #EFEFEF; font-size: 8pt;}";
  echo "-->";
  echo "</style>";

  $dir=opendir (".");											//RELATIVES VERZEICHNIS IN $pfad FFNEN
  $skalierwert = 150;                     //GRE DER SKALIERUNG SETZEN
  $thumbnails = config_read("thumbnails",$pfad."/_config");  //ANZAHL DER BILDER IN EINER REIHE HOLEN
  
  if(chop($thumbnails) > "")  //ABFRAGEN, OB WERT VORHANDEN
  {
    $anzahl = chop($thumbnails);    //WERT SETZEN
  }
  else
  {
    $anzahl = 4;                    //SONST STANDARD
  }
  
  $counter = 0;                     //ZHLERINIT
  
  echo "<center><table class=\"thumb\" border=\"0\" cellpacing=\"0\" cellpadding=\"4\">\n<tr>"; //TABELLE FFNEN

  while ($datei = readdir ($dir)) 						//JEDEN EINTRAG LESEN
  {

      if((is_file($datei) && !preg_match("/.php/",$datei) && !preg_match("/.txt/",$datei))
         && (preg_match("/voll/",$datei) || preg_match("/thumb/",$datei))) //NUR WENN $file EINE DATEI IST UND "matcht"
      {
      

		    if($counter >= $anzahl)   //WENN WERT HHER IST, DANN
        {
          echo "</tr>\n<tr>";     //NEUE REIHE
          $counter=0;     //ZHLER AUF 0
        }
        
        $counter++; //ZHLER FR DURCHLUFE
        
        //BILDINFORMATIONEN HOLEN
        $bild = @getimagesize($datei);
        
        //SKALIEREN
        if($bild[0] > $bild[1]) //WENN BREITE > HHE
        {
          $breite = $skalierwert;
          $hoehe = $skalierwert / ($bild[0] / $bild[1]);   //SKALIERUNG DURCH (BREITE / HHE) -> SKALIERUNGSVERHLTNIS AUSRECHNEN
        }
        elseif($bild[0] < $bild[1])  //WENN BREITE < HHE
        {
          $breite = $skalierwert / ($bild[1] / $bild[0]);  //SKALIERUNG DURCH (HHE / BREITE) -> SKALIERUNGSVERHLTNIS AUSRECHNEN
          $hoehe = $skalierwert;
        }
        elseif($bild[0] = $bild[1])  //WENN BREITE UND HHE GLEICH
        {
          $breite = $skalierwert;
          $hoehe = $skalierwert;
        }

        //TABELLESPALTE UND LINK SCHREIBEN
        echo "<td align=\"center\" valign=\"middle\">
              <a href=\"$datei\" target=\"_blank\">
              <img src=\"$datei\" width=\"$breite\" height=\"$hoehe\" border=\"1\"><br>$datei</a>
              </td>\n";
      }
  }

  closedir($dir);

  echo "</tr></table></center>"; //TABELLE SCHLIEEN
  

?>
