<?php
/**********************************************************************************************
~ AUTOR UND MAINTAINER: Ansatheus  2003 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator - WebSchnuffel
~ DATEI: core_ws.website.php fr Modul Webschnuffel
~ ZWECK: enthlt das Backend fr das Modul
**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

//############################################################################################
//  TOOLS/DEBUG
//############################################################################################
//require_once("../../_at_tools/debug/debugger.php");
//$d = new debug;
//$DEBUG = false;

//PFAD SETZEN
$pfad = "./";

//############################################################################################
//  FUNKTIONEN
//############################################################################################

/*******************************************************************************************
~ NAME: function getstyle($pfad="./")
~ ART: php-Script
~ ZWECK: holt den Style
~ FUNKTIONALITT: $pfad = relativer Pfad zum Parser - optional
~ AUFRUF:	getstyle($pfad="./"));
~ STATUS: funktioniert
*******************************************************************************************/
function getstyle($pfad="./")
{
  require_once("core.config.php");                                  //KONFIGURATIONSDATEI EINBINDEN
  $GLOBALS["iconpfad"] = config_read("iconpfad",$pfad."_config");   //KONFIGURATION FR ICONSHOLEN
  $GLOBALS["stylepfad"] = config_read("stylepfad",$pfad."_config"); //KONFIGURATION FR STYLE HOLEN
  $GLOBALS["stylepfad"] = chop($GLOBALS["stylepfad"]);              //LEERZEICHEN ENTFERNEN
  $GLOBALS["css"] = $pfad . $GLOBALS["stylepfad"]. "/verzeichnis.index.css";  //STYLEPFAD ZUSAMMENBAUEN	
}

/*******************************************************************************************
~ NAME: function menu()
~ ART: php-Script
~ ZWECK: generiert das Men
~ FUNKTIONALITT:
~ AUFRUF:	menu();
~ STATUS: funktioniert
*******************************************************************************************/
function menu()
{
  //DEBUGVARIABLEN IMPORTIEREN
  global $d;
  global $DEBUG;
  global $border;

  //MENVARIABLEN IMPORTIEREN
  global $submenu;
  global $main;
  global $submain;
  
  $fromleft = "10%";  //ENTFERNUNG DER MENPUNKTE VON LINKEM TABELLENRAND - 1 bis 100% der Gesamtbreite
  $fromright = "10%"; //ENTFERNUNG DES MENRANDES VOM INHALTSBEREICH RECHTS  - 1 bis 100% der Gesamtbreite
  $align = "center";    //AUSRICHTUNG DER MENPUNKTE - left|center|right
  
  $contentdaten = @file("_content_ws/content_ws.menu.txt");  //MENUDATEI ALS ARRAY EINLESEN
  if(is_array($contentdaten)) //WENN EINGELESENE DATEI DATEN ENTHLT
  {
    echo "<table width=\"100%\" border=\"$border\" cellspacing=\"0\" cellpadding=\"0\">"; //MENTABELLE AUFBAUEN
    
    foreach($contentdaten as $v)                    //ARRAY DURCHLAUFEN
    {
      if(substr($v,0,1) != "#")                     //KOMMENTARE AUSSCHLIEEN
      {
        $menu_array = explode("|",$v);             //ARRAYELEMENTE AUFSPALTEN
        $ziel_array = explode("=",$menu_array[2]);  //LETZTES ARRAYELEMENT AUFSPALTEN MIT ZIELART UND ZIELORT

        //AUF LINKZIELE UNTERSUCHEN UND ZUSAMMENBAUEN
        if(chop($ziel_array[0]) == "content")       //WENN CONTENTDATEI
        { 
          $ziel = "_self";                          //IM SELBE FENSTER
          
          //FOLGENDE VARIABLEN WERDEN BERGEBEN UND GENUTZT
          //$file = CONTENTDATEI ALS VARIABLE BERGEBEN FR PARSER
          //$main = ZURODUNGSVARIABLE EINES UNTERMENS ZUM HAUPTMENPUNKT
          //$submain = ZURODUNGSVARIABLE EINES UNTERUNTERMENS ZUM UNTERMENPUNKT
          // -> DESHALB WICHTIG, DAMIT IMMER NUR DAS UNTERMEN AUSKLAPPT, DEREN HAUPTMEN ODER EIN UNTERMEN ANGEWHLT WURDE
          $link = "index.php?file=" . $ziel_array[1] . "&main=" . chop($menu_array[3]) ."&submain=" . chop($menu_array[4]) . "&nocount=1";
        }
        elseif(chop($ziel_array[0]) == "url")       //SONST WENN WEBADRESSE ANGEGEBEN WURDE
        {
          $ziel = "_blank";                         //IN NEUEM FENSTER FFNEN
          $link = $ziel_array[1];                   //LINK DIREKT ZUWEISEN
        }

        //AUF MENHIERARCHIE UNTERSUCHEN UND MEN GENERIEREN - ES WIRD HIER EINE SCHACHTELTIEFE VON 2 UNTERMENS UNTERSTTZT
        switch(trim($menu_array[0])) //LEERZEICHEN ENTFERNEN, DA MENSTRUKTUR IN DATEI PER LERRZEICHEN AUFGEBAUT WERDEN KANN
        {
          case "1"  : echo "<tr><td width=\"$fromleft\" class=\"contrast\">&nbsp;</td>\n";
                      echo "<td align=\"$align\" valign=\"middle\" class=\"menu\"><a href=\"$link\" target=\"$ziel\" class=\"submenulink\">&nbsp;$menu_array[1]&nbsp;</a></td>\n";
                      echo "<td class=\"contrast\" width=\"$fromright\">&nbsp;</td></tr>\n";
                      break;
          case "2"  : //WENN HAUPTMEN GLEICHERWEISE IN DATEI UND VARIABLE ZU FINDEN SIND
                      //if((chop($menu_array[1]) == "sub" || $submenu == "sub") && (chop($menu_array[4]) == $main))// || $click))
                      if(chop($menu_array[3]) == $main)
                      {
                        echo "<tr><td class=\"contrast\" width=\"$fromleft\">&nbsp;</td>\n";
                        echo "<td align=\"left\" valign=\"top\">\n";
                        echo "<table width=\"100%\" border=\"$border\" cellspacing=\"0\" cellpadding=\"0\">\n<tr><td class=\"contrast\" width=\"$fromleft\">&nbsp;</td>\n";
                        echo "<td align=\"$align\" valign=\"middle\" class=\"submenu\"><a href=\"$link\" target=\"$ziel\" class=\"submenulink\">&nbsp;$menu_array[1]&nbsp;</a></td></tr>\n";
                        echo "</table></td>";
                        echo "<td class=\"contrast\" width=\"$fromright\">&nbsp;</td></tr>\n";
                      }
                      break;
          case "3"  : //WENN HAUPTMEN UND UNTERMEN GLEICHERWEISE IN VARIABLEN ZU FINDEN SIND
                      if(chop($menu_array[3]) == $main && chop($menu_array[4]) == $submain)
                      {
                        echo "<tr><td class=\"contrast\" width=\"$fromleft\">&nbsp;</td>\n";
                        echo "<td align=\"left\" valign=\"top\">\n";
                        echo "<table width=\"100%\" border=\"$border\" cellspacing=\"0\" cellpadding=\"0\"><tr><td class=\"contrast\" width=\"$fromleft\">&nbsp;</td>\n";
                        echo "<td align=\"left\" valign=\"top\">\n";
                        echo "<table width=\"100%\" border=\"$border\" cellspacing=\"0\" cellpadding=\"0\">\n<tr><td class=\"contrast\" width=\"$fromleft\">&nbsp;</td>\n";
                        echo "<td align=\"$align\" valign=\"middle\" class=\"submenu\"><a href=\"$link\" target=\"$ziel\" class=\"submenulink\">&nbsp;$menu_array[1]&nbsp;</a></td></tr>\n";
                        echo "</table></td></tr>\n";
                        echo "</table></td>\n";
                        echo "<td class=\"contrast\" width=\"$fromright\">&nbsp;</td></tr>\n";
                      }
                      break;
          default   : break;
        }
      }
    }
    
    echo "</table>"; //MENTABELLE SCHLIEEN
  }

if($DEBUG) $d->var_dumping($contentdaten);
if($DEBUG) $d->ausgabe_array_notarray($contentdaten);
}

/*******************************************************************************************
~ NAME: function content($file,$url)
~ ART: php-Script
~ ZWECK: generiert den Inhalt der Hauptanzeige
~ FUNKTIONALITT: $file = Contentdatei mit Inhalt
~                 $url = steht fr "externe" Datei wie HTML oder Internetadresse
~                           optional
~ AUFRUF:	content($file,$extern);
~ STATUS: funktioniert
*******************************************************************************************/
function content($file,$url=FALSE)
{
  global $pfad; //PFADVARIABLE IMPORTIEREN
  
  if($url)
  {
    echo "HALLO";
  }
  else
  {
    if(!$file) { $file = "_content_ws/content_ws.home.txt"; } //STANDARD-CONTENTDATEI FR DEN ERSTEN AUFRUF ZUWEISEN
    $content_other_file = $file;                  //$content_other_file FR PARSER SETZEN
    include($pfad . "core.parser.php");           //PARSER INCLUDEN
    //return $content_other_file;
    //include("core_ws.parserwrapper.php");
    //parserwrapper::parserinclude();
  }
}

/*******************************************************************************************
~ NAME: function content_other($file)
~ ART: php-Script
~ ZWECK: generiert den Inhalt der anderen Bereiche
~ FUNKTIONALITT: $file = Contentdatei mit Inhalt
~ AUFRUF:	content_other($file)
~ STATUS: funktioniert
*******************************************************************************************/
function content_other($file_other)
{
  global $pfad; //PFADVARIABLE IMPORTIEREN

  if($url)
  {
    echo "HALLO";
  }
  else
  {
    $content_other_file = $file_other;              //$content_other_file FR PARSER SETZEN
    //include($pfad . "core.parser.php");       //PARSER INCLUDEN
    //include("core_ws.parserwrapper.php");
    //parserwrapper::parserinclude();
  }
}

//$content_other_file = $GLOBALS["content_other_file"];
//echo $content_other_file;
//include($pfad . "core.parser.php");
?>
