<?php
/**********************************************************************************************
*	AUTOR:					Andreas Theusner,  2002 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM:       AT Contenator
~ DATEI:          core.schnufflodondron.php
~	ZWECK:					PHP-Suchmaschine Schnufflodondron
~                 - automatisches generieren eines Linkkataloges fr Dokumente
~	VERWENDUNG:			z.B. fr Handbcher, Dokumentationen oder hnliches
~	FUNKTIONALITT:	- es wird zwischen Verzeichnissen und Dateien unterschieden
~									- es werden zuerst alle Dateien im Ausgangsverzeichnis
~										aufsteigend sortiert ausgegeben und danach nach Verzeichnissen
~										ebenfalls aufsteigend die Dateien in diesen ausgegeben
~									- jeder geparste Eintrag wird als Link generiert
~									- es wird untersucht, ob der Aufruf der index.php
~										per Webbrowser von einem Server (z.B. Apache) aufgerufen
~										wird oder lokal mit einem entsprechendem Tool (z.B. Zend IDE)
~										generiert und dann gestartet wird bzw. als HTML-Datei dort
~										abgespeichert wird
~									- Ausgangspunkt fr das Generieren ist immer das aktuelle Verzeichnis
~ EINSCHRNKUNGEN:- automatisch wird nur ein Unterverzeichnis ab ServerRoot untersttzt
~									- liegt das Schnufflodondron ab 2. Unterverzeichnis des ServerRoots,
~										mu der Pfad ab diesem Verzeichnis gesetzt werden ($unterverzeichnispfad)
~									Bsp. www.suchen.de (ServerRoot -> Domain)
~														|- inhalt (1.Unterverzeichnis -> automatisch erkannt)
~																	|- suche (2. Unterverzeichnis -> $unterverzeichnispfad = "/suche";)
~									- bei weiteren Unterverzeichnissen bietet Apache die entsprechende Lsung an
~									- Verzeichnis mu im Hauptserverpfad liegen (server/verzeichnis/index.php)
~	AUFRUF:					- Browser: Servername/Verzeichnisname/index.php
~ HINWEISE:				alle Verzeichnisse und Dateien mssen im Verzeichnis von index.php / index.htm
~									liegen
~ STATUS:					in Bearbeitung
**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*           Funktionen
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//INCLUDES
include_once("core.config.php");
$iconpfad = config_read("iconpfad",$pfad."_config") . "/";  //KONFIGURATION FR ICONS HOLEN

//VARIABLEN FR ICONS
$img_schnufflo = $iconpfad . "/core.schnufflo_schnufflo.gif";
$img_schnuffel = $iconpfad . "/core.schnufflo_schnuffel.gif";
/*******************************************************************************************
~ AUTOR: 	Andreas Theusner , 06.01.03
~ ZWECK: 	rekursives Auslesen aller Dateien und Verzeichnisse ab Startverzeichnis
~         zur Ermittlung der Anzahl der Dateien
~ FUNKTIONALITT:
~		$dir = Startverzeichnis - alle Verzeichnisse darunter werden rekursiv durchsucht
~		$fp = Handle
~ AUFRUF:	count_files_dirs(".");
*******************************************************************************************/  
//GLOBALE VARIABLEN SETZEN UND INITIALISIEREN
$filecounter = 0; 
$dircounter = 0;

function count_files_dirs ($dir) 
{ 
	global $filecounter; 
	global $dircounter;
	
	$fp=opendir($dir);
	
	while($datei=readdir($fp)) 
	{ 
		if (is_dir("$dir/$datei") && $datei!="." && $datei!=".."  && (substr($datei,0,1) != "_")) //AUSSCHLIEEN
		{ 
			count_files_dirs ("$dir/$datei");                                                        //REKURSIVER AUFRUF
			$dircounter++;                                                                           //VERZEICHNIS HOCHZHLEN
		} 
		else 
		{ 
			if($datei!="." && $datei!=".." && !preg_match("/.php/",$datei)
			   && !preg_match("/core/",$datei) && !preg_match("/modul/",$datei) && !preg_match("/index/",$datei)
         && !preg_match("/install/",$datei) && !preg_match("/config/",$datei)
         && (substr($datei,0,1) != "_"))   //AUSSCHLIEEN
			{
				$filecounter++;                    //DATEI HOCHZHLEN
			}
		} 
	}
	 
	closedir($fp); 
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*           HAUPTPROGRAMM
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//HTML-KOPF SCHREIBEN
echo <<<KOPF
	<html>
		<head>
			<title>Schnufflodondron</title>
      <meta http-equiv="expires" content="0">
      <meta http-equiv="pragma" content="no-cache">
      <meta http-equiv="cache-control" content="no-cache">
      <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
		</head>
	<body bgcolor="#EFEFEF">
		<font face="Tahoma, Arial, Helvetica, Courier New" size=2>
KOPF;
//-------------------------------------------------------------------------------------------
//WIRD DIESER BEREICH AKTIVIERT, HAT MAN EINEN EINFACHEN ZUGRIFFSSCHUTZ MIT PAWORT ABFARGE
/*//PASSWORTABFRAGE
if(!$login)
{
echo "<center>Zugriff auf <b>" . strrchr(getcwd(),"/") . "</b></center>"; //ZUGRIFFSVERZEICHNIS AUSGEBEN

echo <<<PASSWORT
<center>
<table width="40%" cellpadding=4 cellspacing=0 border=0>
	<tr>
		<td align="center" valign="middle">
			<form action="$PHP_SELF?login=1" method="post">
				<table width="100%" border=0>
					<tr>
						<td align="left" valign="middle">Benutzer</td>
						<td align="left" valign="middle"><input type="text" name="user" size="20"></td>
					</tr>
					<tr>
						<td align="left" valign="middle">Passwort</td>
						<td align="left" valign="middle"><input type="password" name="kennwort" size="20"></td>
					</tr>
					<tr>
						<td align="center" valign="middle" colspan=2>
							<input type="submit" name="loginbutton" value=" Login ">
							<input type="reset" name="resetten" value="Reset ">
						</td>
					</tr>
				</table>
			</form>
		<td>
	</tr>
</table>
</center>
PASSWORT;
}

//PASSWORT UND BENUTZER VERGLEICHEN
if($login == 1)
{
	if($user && $kennwort)
	{
		if(($user == "user") && ($kennwort == "kennwort"))
		{
			$loginsuccess = true;
		}
		else
		{
			echo "Benutzer und/oder Passwort falsch!<br>";
			echo "<a href=\"$PHP_SELF\">Neuer Versuch</a>";
			$loginsuccess = false;
		}
	}
	else
	{
		echo "Benutzer und/oder Passwort nicht eingegeben!<br>";
		echo "<a href=\"$PHP_SELF\">Neuer Versuch</a>";
		$loginsuccess = false;
	}
}*/
$loginsuccess = true;  //MU DEAKTIVIERT WERDEN BEI AKTIVIERUNG DES PAWORTSCHUTZES
//--------------------------------------------------------------------------------------
//AUSLESEN UND AUFBAU DES INDEXES
//--------------------------------------------------------------------------------------
if($loginsuccess) //HAUPT-IF
{

//LOGOUT
echo "<a href=\"javascript:self.close()\">Schlieen</a><p>";

//SUCHBEREICH - DIE SUCHWERT WERDEN AUTOMATISCH AN DIE SUCHENGINE BERGEBEN -> FUNKTION DES FORM-TAGS
echo <<< SUCHE
<img src="$img_schnufflo">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src="$img_schnuffel">
<form action="core.schnufflo_suche.php?login=$loginsuccess" method="post">
<table width=100% cellpadding=0 cellspacing=4 border=0 bgcolor="#ccddee">
<tr><td align="left" valign="middle">
	<font size=3><b>Suchen nach</b></font>&nbsp;&nbsp;
		<input type="text" name="suchwert" size="50" value="$suchwert">
		<input type="submit" name="suchbutton" value="Suche starten">
		<font size=1><a href="core.schnufflo_hilfe.php" target="_blank">Hilfe zum Schnufflodondron</a></font>
</td></tr>
<tr><td align="left" valign="middle">
	<font size=3><b>Optionen:</b></font>
	<font size=1>
		&nbsp;&nbsp;Alles&nbsp;&nbsp;
			<input type="checkbox" name="suchen_alles">
		&nbsp;&nbsp;Anzahl der Inhaltszeilen:&nbsp;&nbsp;
			<input type="text" size="2" name="zeilen" value="4" maxlength="2">
		&nbsp;&nbsp;Anzahl der Zeichen pro Inhaltszeile:&nbsp;&nbsp;
			<input type="text" size="5" name="zeichen" value="1000" maxlength="5">
		&nbsp;&nbsp;Zeilen mit Suchbegriff / Zeilen von oben:&nbsp;&nbsp;
			<input type="checkbox" name="nur_fundstellen">
	</font>
</td></tr>
<!--</table>-->
<!--</form>-->
<tr><td align="left" valign="middle">
SUCHE;

//DOKUMENTINDEX GENERIEREN
//------------------------

$server = $SERVER_NAME;												//HOLT DEN SERVERNAME 
$local = getcwd();														//HOLT DEN PFAD FR DAS AKTUELLE VERZEICHNIS  
$drive = "";																	//INIT
$unterverzeichnispfad = config_read("unterverzeichnispfad");  //KONFIGURATION HOLEN;          //WENN ROOTVERZEICHNIS AB 2. UNTERVERZEICHNIS VOM SERVERROOT IST,																							//  MU DER PFAD AB 2. UNTERVERZEICHNIS HIER GESETZT WERDEN	- OFFENBAR NICHT IMMER NOTWENDIG
                                              //AUF WINDOWS-SYSTEMEN ABER OFFENBAR SCHON AB DEM 1. UNTERVERZEICHNIS DES SERVERROOTS
//AUFRUFART ABFRAGEN                          //  MIT FHRENDEM ODER NACHGESTELLTEM / (SLASH)
if($server)																		//WENN VARIABLE INHALT HAT - AUFRUF PER WEBBROWSER
{
	$root = $local;															//AKTUELLES VERZEICHNIS ALS ROOT SETZEN
	$dir = $unterverzeichnispfad . strrchr($local,"/");									//LETZTES VERZEICHNIS EXTRAHIEREN             
	$drive = "http://" . $SERVER_NAME . $dir;		//SERVER- UND VERZEICHNISPFAD ZUSAMMENBAUEN
	//echo "<b><u>Index von $drive </u></b><p>";	//BERSCHRIFT AUSGEBEN
	$indexausgabe = $drive;											//BERSCHRIFT SPEICHERN FR SPTERE AUSGABE
}
else																					//SONST - AUFRUF LOKAL (WENN DATEI index.htm ERZEUGT)
{
	$root = $local;															//AKTUELLES VERZEICHNIS ALS ROOT SETZEN
	$drive = $local;														//VERZEICHNISPFAD ZUSAMMENBAUEN
	//echo "<b><u>Index von $local </u></b><p>";	//BERSCHRIFT AUSGEBEN 
	$indexausgabe = $local;											//BERSCHRIFT SPEICHERN FR SPTERE AUSGABE
}

//LINKINDEX GENERIEREN
$verz=opendir ($root);												//AKTUELLES VERZEICHNIS FFNEN

while ($file = readdir ($verz)) 							//JEDEN EINTRAG LESEN
{
	//if(is_dir($file) and $file != '.' and $file != '..' and !preg_match("/.php/",$file2) and !preg_match("/core/",$file2) and !preg_match("/modul/",$file2))	//UNTERSUCHEN OB VERZEICHNIS
	if(is_dir($file) and $file != '.' and $file != '..' and (substr($file,0,1) != "_"))
	{																										//	WERTE . UND .. UND _ ALS ERSTES ZEICHEN AUSSCHLIEEN -> WERDEN ALS VERZEICHNISSE GESEHEN
		$dirliste[] = $drive . "/" .$file;        //VERZEICHNISS IN ARRAY SCHREIEBN
    $pfad = $file . "/";											//PFAD ZUSAMMENBAUEN    
		$verz2 = opendir($file);									//WENN UNTERVERZEICHNIS FFNEN
		while ($file2 = readdir ($verz2)) 				//JEDEN EINTRAG LESEN
		{
			if($file2 != '.' && $file2 != '..' && !preg_match("/.php/",$file2) && !preg_match("/core/",$file2) && !preg_match("/modul/",$file2) && !preg_match("/index/",$file2)
         && !preg_match("/install/",$file2) && !preg_match("/config/",$file2))		//WERTE . UND .. UND PHP-DATEIEN AUSSCHLIEEN -> WERDEN ALS VERZEICHNISSE GESEHEN
			{
				if(is_dir($pfad.$file2))              //WENN EINTRAG VERZEICHNIS IST (KOMPLETTER PFAD MU ANGEGEBEN WERDEN)
				{
					//$dirliste[] = $pfad."/".$file2;  //KLAPPT NICHT - ERZEUGT KEIN http://server/verzeichnsname
					$bold_ein = "<b>";                  //HERVORHEBUNG EIN
					$bold_aus = "</b>";
					unset($edit);
					//$edit = "&nbsp;&nbsp;<font size=1><a href=\"$drive/$pfad$file2\"><img src=\"core.schnufflo_dir.gif\" border=0 alt=\"Verzeichnis ffnen\"></a>";
					$dirliste[] = "$drive/$pfad$file2"; //VERZEICHNISS IN ARRAY SCHREIEBN - VERZEICHNISLISTE IN DER SUCHMASKE
				}                                     //SONST
				else
				{
					$bold_ein = "";                     //HERVORHEBUNG AUS
					$bold_aus = "";
					
					//BEARBEITUNG BEI TXT-DATEIEN ZULASSEN - GRAFIK ALS LINK GENERIEREN
          if(preg_match("/.txt/",$file2))			
					{
					 unset($edit);
					 //$edit = "&nbsp;&nbsp;<a href=\"core.schnufflo_edit.php?datei=./$pfad$file2&editieren=1\" target=\"_blank\"><img src=\"core.schnufflo_edit.gif\" border=0 alt=\"Datei bearbeiten\"></a>";
			    }
				}

        if(is_dir($pfad.$file2))
        {
          $nur_verzeichnisse[]  = "<font size=1><a href=\"$drive/$pfad$file2\">$bold_ein$pfad$file2$bold_aus</a>$edit</font>\n<br>";	//LINK FR UNTERVERZEICHNISSE GENERIEREN UND IN ARRAY SCHREIBEN
        }
        else
        {   //echo "AT1: $pfad$file2<br>"; //DEBUG
				  $pufferverz[] = "<font size=1><a href=\"$drive/$pfad$file2\">$bold_ein$pfad$file2$bold_aus</a>$edit</font>\n<br>";	//LINK FR UNTERVERZEICHNISSE MIT DATEIEN GENERIEREN UND IN ARRAY SCHREIBEN
				}
				unset($edit);
			}
		}

		closedir($verz2);													//VERZEICHNIS SCHLIESSEN
	}
	else																				//WENN EINTRAG KEIN VERZEICHNIS
	{
		if($file != '.' and $file != '..' 				//WERTE . UND .. UND INDEX-, CCORE- UND MODULE/MODUL-DATEIEN AUSSCHLIEEN
			and !preg_match("/index/",$file) and !preg_match("/.php/",$file) and !preg_match("/core/",$file) and !preg_match("/modul/",$file)
      and !preg_match("/install/",$file) and !preg_match("/config/",$file) && (substr($file,0,1) != "_"))
		{
			//BEARBEITUNG BEI TXT-DATEIEN ZULASSEN - GRAFIK ALS LINK GENERIEREN
			if(preg_match("/.txt/",$file))
			{
				unset($edit);
				//$edit = "&nbsp;&nbsp;<a href=\"core.schnufflo_edit.php?datei=./$file&editieren=1&savefileroot=1\" target=\"_blank\"><img src=\"core.schnufflo_edit.gif\" border=0 alt=\"Datei bearbeiten\"></a>";
			}
			 //echo "AT2: $drive/$file<br>"; //DEBUG
			$pufferfile[] = "<font size=1><a href=\"$drive/$file\">$file</a>$edit</font>\n<br>";	//LINK GENERIEREN UND IN ARRAY SCHREIBEN
			unset($edit);                               
			
		}
	}
}

closedir($verz); 															//VERZEICHNIS SCHLIESSEN    

//echo <<< VERZEICHNISSUCHE
//<form action="suche.php?login=$loginsuccess" method="post">
//<table width=100% cellpadding=0 cellspacing=4 border=0 bgcolor="#ccddee">
//<tr><td align="left" valign="middle">      
//VERZEICHNISSUCHE;

//VERZEICHNISSE IN LISTE SCHREIBEN UND AUSGEBEN
//SOLLTE HIER AUS SICHERHEITSGRNDEN DEAKTIVIERT SEIN, DENN NICHT JEDER SOLLTE ALLE VERZEICHNISSE
//(AUCH NICHT SICHTBARE) SEHEN KNNEN
/*if(is_array($dirliste))
{                      
	echo "<p><font size=3><b>Suchen im Verzeichnis:</b></font> <select name=\"verzeichnisliste\"><br>";
	echo "<option value=alle>alle</option><br>";
	foreach($dirliste as $k => $v)
	{
 		echo "<option value=$v>$v</option><br>";
 	}                                        
 	echo "</select>";
 	//echo "<font size=1> Anzahl: " . count($dirliste) . "</b></font>"; //VERZEICHNISANZAHL AUSGEBEN
}*/

count_files_dirs("."); //DATEIEN ZHLEN
                 
echo <<<SUCHE
</td></tr>
<tr><td align="left" valign="middle">
	<font size=3><b>Statistik:</b></font>
	<font size=1>
SUCHE;
  
  //VERZEICHNISSTATISTIK SOLLTE HIER AUS SICHERHEITSGRNDEN DEAKTIVIERT SEIN, DENN NICHT JEDER SOLLTE ALLE VERZEICHNISSE
	//(AUCH NICHT SICHTBARE) SEHEN KNNEN
	echo "Dateien gesamt: $filecounter"; //&nbsp;&nbsp;|&nbsp;&nbsp;Verzeichnisse gesamt: $dircounter";//. count($dirliste);
	
echo <<<SUCHE
	</font>
</td></tr>
<tr><td align="middle" valign="middle" bgcolor="aliceblue">
	<font size=1>
  	<b>Autor:</b> Ansatheus  2002-2014 - <b>Lizenz:</b> <a href="gnu_gpl.htm" target="_blank">GNU-Lizenz</a>
	</font>
</td></tr>
</table>
</form>                                                                  
      
SUCHE;

 
echo "\n<b><u>Index von $indexausgabe </u></b><p>";	//BERSCHRIFT AUSGEBEN 

//LINKINDEX SORTIERT SCHREIBEN
//	DATEIEN SCHREIBEN
if(is_array($pufferfile))											//WENN WERTE IN ARRAY
{
	sort($pufferfile);													//AUFSTEIGEND SORTIEREN

	foreach($pufferfile as $k => $v)						//JEDES ARRAYELEMENT DURCHLAUFEN
	{
		echo $v;																	//VALUE AUSGEBEN
	}
}

//UNTERVERZEICHNISSE MIT DEREN DATEIEN SCHREIBEN
if(is_array($pufferverz))											//ANALOG OBEN
{
	sort($pufferverz);

	foreach($pufferverz as $k => $v)
	{
		echo $v;
	}
}

//SOLLTE HIER DEAKTIVIERT WERDEN, WEIL IN VERZEICHNISSEN MIT DER index.php VON
//AT CMS FEHLERMELDUNGEN BEIM AUFRUF DES VERZEICHNISSES AUSGEGEBEN WERDEN,
//WENN DAS VERZEICHNIS DIE index.php VON AT CMS ENTHLT, DA DIESE DIE parser.php
//IM ROOTVERZEICHNISS INCLUDED UND DEN RELATIVEN PFAD AUTOMATISCH SELBST GENERIERT
//ENTHALTEN SIE ANDERE INDEX-DATEIEN, WERDEN DIESE KORREKT ANGEZEIGT (APACHE)
/*//NUR UNTERVERZEICHNISSE SCHREIBEN
if(is_array($nur_verzeichnisse))					//ANALOG OBEN
{
	sort($nur_verzeichnisse);

	foreach($nur_verzeichnisse as $k => $v)
	{
		echo $v;
	}
} */

} //ENDE HAUPT-IF
//FU HTML-SCHREIBEN
echo <<<FUSS
		</font>
	</body>
	</html>
FUSS;
?>
