<?php
/*##########################################################################################
~ AUTOR: Andreas Theusner,  2002 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator
~ DATEI:	core.schnufflo_suche.php
~ ZWECK: - PHP-Suchengine des Schnufflodondrons
~        - durchsucht rekursiv alle Verzeichnisse, Unterverzeichnisse und Dateien nach einem
~				 	 Suchmuster und gibt sie per Link generiert aus
~				 - Ausgangspunkt ist immer das Verzeichnis, in dem diese Datei liegt
~ STATUS: einsetzbar
###########################################################################################
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*           Funktionen
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*******************************************************************************************
~ AUTOR: 	Andreas Theusner , 04.11.02
~ ZWECK: 	rekursives Auslesen aller Dateien und Verzeichnisse ab Startverzeichnis
~         und Ausgabe als Links
~ FUNKTIONALITT:
~		$dir = Startverzeichnis - alle Verzeichnisse darunter werden rekursiv durchsucht
~		$ausgabe = Ausgabe in den Browser - Trick zur Ermittlung der Anzahl der Fundstellen
~							 wenn zuerst false - Rckgabe der Trefferanzahl - dann true, wird zuerst
~							 die Trefferanzahl ermittelt und dann werden die Treffer ausgegeben
~							 - kaum merklich langsamer
~ BEMERKUNG: Grundgerst aus dem Internet
*******************************************************************************************/
$trefferall = 0; //GLOBALE VARIABLE INITIALISIEREN

function all_dir_files ($dir,$ausgabe=true)
  {
  	global $trefferall;					//GLOABALE VARIABLE IMPORTIEREN
  	
		$fp=opendir($dir);         	//VERZEICHNIS FFNEN
		while($datei=readdir($fp))  //ALLE EINTRGE IN DIESEM VERZEICHNIS AUSLESEN
    {    	
			if (is_dir("$dir/$datei") && $datei!="." && $datei!=".." && (substr($datei,0,1) != "_"))   //WENN VERZEICHNIS UND NICHT . ODER ..
      {
      	$trefferall++; //TREFFER HOCHZHLEN
      	
        //$edit = "&nbsp;&nbsp;<a href=\"$dir/$datei\"><img src=\"core.schnufflo_dir.gif\" border=0 alt=\"Verzeichnis ffnen\"></a>"; //GRAFIK ALS LINK GENERIEREN
        
        if($ausgabe)	//NUR WENN AUSGABE TRUE IST
        {	 //SOLLTE DEAKTIVIERT SEIN, DA BEI DEN VERZEICHNISSEN MIT index.php VON AT CMS FEHLER AUSGEGEBEN WERDEN WEGEN INCLUDE DES PARSERS
           //SIEHE IN schnufflodondron.php UNTER $nur_verzeichnisse AUSGEBEN
      		//echo "<font size=2><a href=\"$dir/$datei\"><b>$dir/$datei</b></a>$edit</font><br>";   //VERZEICHNIS ALS LINK GENERIERT AUSGEBEN
        }
        
      	all_dir_files("$dir/$datei",$ausgabe);	//REKURSIVER AUFRUF DER FUNKTION ZUM ERNEUTEN DURCHLAUFEN DES NCHSTEN UNTERVERZEICHNISSES
        unset($edit);
      }
			else                      //SONST
      {
        if($datei != "." && $datei != ".." && !preg_match("/.php/",$datei) && !preg_match("/index/",$datei)
        	 && !preg_match("/core/",$datei) && !preg_match("/modul/",$datei) && !preg_match("/install/",$datei)
			     && !preg_match("/config/",$datei) && (substr($datei,0,1) != "_")) 	//WENN NICHT . UND .. ANDERE DATEIEN UND KEINE PHP-DATEIEN AUSSCHLIE?EN
        {
        	$trefferall++; //TREFFER HOCHZHLEN
        	
        	if(preg_match("/.txt/","$dir/$datei"))
        	{
        		//$edit = "&nbsp;&nbsp;<a href=\"core.schnufflo_edit.php?datei=$dir/$datei&editieren=1\" target=\"_blank\"><img src=\"core.schnufflo_edit.gif\" border=0 alt=\"Datei bearbeiten\"></a>"; //GRAFIK ALS LINK GENERIEREN
        	}
        	
        	if($ausgabe) //NUR WENN AUSGABE TRUE IST
        	{	
      			echo "<font size=1><a href=\"$dir/$datei\">$dir/$datei</a>$edit</font><br>";	//DATEI ALS LINK GENERIERT AUSGEBEN
        	}
        	
      		unset($edit);
        }
      }
		}

    closedir($fp);              //VERZEICHNIS SCHLIEEN
    
    return $trefferall;
	}

/*******************************************************************************************
~ AUTOR: 	Andreas Theusner , 04.11.02
~ ZWECK: 	rekursives Auslesen aller Dateien und Verzeichnisse ab Startverzeichnis
~         und Ausgabe als Links, wo Suchwert
~ DATEIEN: es werden alle Dateien durchsucht auer die im Code ausgeschlossen werden
~ FUNKTIONALITT:
~		$dir = Startverzeichnis - Startpunkt der Suche
~		$searchvalue = Suchwert - String, nach dem in Dateien gesucht wird
~		$rows = Anzahl der Zeilen - Anzahl der Ausgabezeilen des Inhalts einer Datei
~		$chars = Anzahl der Zeichen - anzuzeigende Zeichen in einer Zeile - ntig, wenn
~						 eine Zeile viele Zeichen ohne Zeilenumbruch hat
~ 	$find = nur Fundstellen in die Inhaltsausgabe - Inhaltsausgabe entweder der Zeilen
~						der Datei in der sich der gesuchte String befindet oder ab der ersten Zeile
~		$ausgabe = Ausgabe in den Browser - Trick zur Ermittlung der Anzahl der Fundstellen
~							 wenn zuerst false - Rckgabe der Trefferanzahl - dann true, wird zuerst
~							 die Trefferanzahl ermittelt und dann werden die Treffer ausgegeben
~							 - kaum merklich langsamer
~		- es werden alle Dateien, die den Suchwert enthalten, gefunden und alle Dateien,
~			die im Pfad den Suchwert enthalten, selbst aber diesen nicht inhaltlich enthalten
~	HINWEISE: - es wird automatisch auf Gro- und Kleinschreibung geachtet
~						- es wird automatisch nach allen bereinstimmenden Strings gesucht,
~							d.h. je mehr Zeichen eingegeben werden, desto genauer ist die Suche
*******************************************************************************************/
$treffer = 0; //GLOBALE VARIABLE INITIALISIEREN

function search_dir_files ($dir=".",$searchvalue="",$rows=4,$chars=1000,$find=false,$ausgabe=true)
  {
  	global $treffer; //GLOBALE VARIABLE IMPORTIEREN

		$fp=opendir($dir);         	//VERZEICHNIS FFNEN
		while($datei=readdir($fp))  //ALLE EINTRGE IN DIESEM VERZEICHNIS AUSLESEN
    {
			if (is_dir("$dir/$datei") && $datei!="." && $datei!=".." && (substr($datei,0,1) != "_"))   //WENN VERZEICHNIS UND NICHT . UND .. UND MIT _ AM ANFANG
      {
        search_dir_files("$dir/$datei",$searchvalue,$rows,$chars,$find,$ausgabe);	//REKURSIVER AUFRUF DER FUNKTION ZUM ERNEUTEN DURCHLAUFEN DES NCHSTEN UNTERVERZEICHNISSES
      }
			else                      //SONST
      {
        if($datei != "." && $datei != ".." && !preg_match("/.php/",$datei) && (substr($datei,0,1) != "_")
        && !preg_match("/core/",$datei) && !preg_match("/modul/",$datei) && !preg_match("/index/",$datei)
        && !preg_match("/install/",$datei) && !preg_match("/config/",$datei)) 	//WENN NICHT . UND .. UND PHP-DATEIEN
        {
        	//DATEIEN VON DER SUCHE AUSSCHLIEEN
          if(!strchr(".gif","$dir/$datei")
          	&& !strchr(".tif","$dir/$datei")
          	&& !strchr(".bmp","$dir/$datei")
            && !strchr(".pdf","$dir/$datei")
            )
          {  
          	//echo "AT1: $dir/$datei Zeile: " .  __LINE__ . "<br>"; //DEBUG
         		if($file = @fopen("$dir/$datei","r"))  		//DATEI IM LESEMODUS FFNEN  - SCHWIERIGKEITEN BEI SYSTEMDATEIEN MIT . BEGINNEND ?
         		{                                         //ERFOLG DES FFNENS ABFRAGEN, DENN BEI VON ANDEREN PROGRAMMEN GEFFNETEN DATEIEN
        		                                          //(GELOCKT) ERSCHEINT SONST EINE FEHLERMELDUNGEN TROTZ VORANGESTELLTEM @
          	  while($line = fgetss($file,10000))		//10000 ZEICHEN EINLESEN
          	  {
          		  unset($inhalt);
          		  unset($inhalt_array);
           		  if(preg_match("/$searchvalue/",$line))	//ZEICHEN AUF BEREINSTIMMUNG PRFEN
            	  {
            		  $treffer++; //TREFFER HOCHZHLEN
            		
            		  //INHALT DER DATEI NOCHMALS AUSLESEN
            		  //echo "AT2: $dir/$datei<br>";  //DEBUG
            		  if($file2 = @fopen("$dir/$datei","r"))
           		    {
            		    while($line2 = fgetss($file2,$chars))
            		    {
           			      if($find) //WENN 'NUR FUNDSTELLEN' GEWHLT IST
            			    {
            				    if(preg_match("/$searchvalue/",$line2)) //NUR FUNDSTELLEN IN ARRAY
            				    {
            					    $inhalt_array[] = $line2;
            				    }
            			    }
            			    else 	//SONST
            			    {
            				    $inhalt_array[] = $line2; //DIE ERSTEN ZEILEN, BEGRENZT DURCH $rows
            			    }
            		    }
            		    @fclose($file2);
                  }
            		  //INHALT IN STRING UMWANDELN
            		  //UNTERSUCHT IN DER BEDINGUNG, OB ARRAYELEMENTE < ALS DIE ANGEGEBENE ZEILENANZAHL IST
            		  //WENN JA, WIRD SIE AUF DIE ANZAHL DER ARRAYELEMENTE REDUZIERT
            		  $inhalt = "<ol type=\"disc\">"; //LISTE ANLEGEN

            		  for($i=0;count($inhalt_array)>$rows-1 ? $i<=$rows-1 : $i<=count($inhalt_array);$i++)
            		  {
            			  $inhalt = $inhalt . "<li>" . $inhalt_array[$i] . "</li>"; //STRING ALS LISTENPUNKT ERZEUGEN
            		  }
									
            		  //GRAFIK ALS LINK GENERIEREN -ZUR BEARBEITUNG
            		  if(preg_match("/.txt/","$dir/$datei"))
            		  {            				
            				  //$edit = "&nbsp;&nbsp;<a href=\"core.schnufflo_edit.php?datei=$dir/$datei&editieren=1\" target=\"_blank\"><img src=\"core.schnufflo_edit.gif\" border=0 alt=\"Datei bearbeiten\"></a>";
            		  }

            		  $inhalt = $inhalt . "</ol>"; //LISTE SCHLIEEN
             		  $ergebnis_array[] = "<p><font size=1><a href=\"$dir/$datei\">$dir/$datei</a>$edit<br>$inhalt</font>"; //WENN BEREINSTIMMUNG IN ARRAY
             		  unset($edit); //VARIABLE LSCHEN, DAMIT INHALT NICHT HINTER ANDEREUNZULSSIGE DATEIEN GESCHRIEBEN WIRD
            	  }
          	  }
          	  @fclose($file);		//DATEI SCHLIEEN
          	}
          }

          //BEI DATEIEN, DIE NICHT DURCHSUCHT WERDEN KNNEN, DEN DATEINAMEN DURCHSUCHEN
          //BZW. DATEIEN, DIE IM PFADNAMEN DEN GESUCHTEN WERT ENTHALTEN
          if(preg_match("/$searchvalue/","$dir/$datei"))	//ZEICHEN AUF BEREINSTIMMUNG PRFEN
          {
          	$treffer++;  //TREFFER HOCHZHLEN
          	
          	//GRAFIK ALS LINK GENERIEREN - ZUR BEARBEITUNG
          	if(preg_match("/.txt/","$dir/$datei"))
            {
            	//$edit = "&nbsp;&nbsp;<a href=\"core.schnufflo_edit.php?datei=$dir/$datei&editieren=1\" target=\"_blank\"><img src=\"core.schnufflo_edit.gif\" border=0 alt=\"Datei bearbeiten\"></a>";
            }

          	$ergebnis_array[] = "<font size=1><a href=\"$dir/$datei\">$dir/$datei</a>$edit</font><br>"; //WENN BEREINSTIMMUNG IN ARRAY
          	unset($edit); 
          }

        }

      }
		}

    closedir($fp);              //VERZEICHNIS SCHLIEEN

    //ERGEBNISSE AUSGEBEN
    if(is_array($ergebnis_array) && $ausgabe)	//WENN ERGEBNISSE VORHANDEN
    {
    	$ergebnis_array = array_unique($ergebnis_array);	//DOPPELTE EINTRGE ENTFERNEN -> NUR EINE DATEI ANZEIGEN
    	foreach($ergebnis_array as $k => $v)							//ARRAY DURCHLAUFEN
    	{
     		echo "$v\n";								//ARRAYELEMENT AUSGEBEN
    	}
    }

    return $treffer;
	}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*           HAUPTPROGRAMM
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//HTML-KOPF SCHREIBEN
echo <<<KOPF
	<html>
		<head>
			<title>Ergebnis der Suche</title>
      <meta http-equiv="expires" content="0">
      <meta http-equiv="pragma" content="no-cache">
      <meta http-equiv="cache-control" content="no-cache">
      <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
		</head>
	<body bgcolor="#EFEFEF">
		<font face="Tahoma, Arial, Helvetica, Courier New" size=2>
		<a href="core.schnufflodondron.php?loginsuccess=1&login=1&user=zeadmin&kennwort=zeadmin">Zurck</a><p>
		<table width=100% cellpadding=0 cellspacing=4 border=0 bgcolor="#ccddee">
			<tr><td align="left" valign="middle">
		<font size=3><b>gesucht nach:&nbsp;&nbsp;
KOPF;

//DEBUG
//echo "SUCHWERT: $suchwert<br>";
//echo "LOGIN: $login<br>";
//echo "SEARCHVALUE: $searchvalue<br>";

if($login)		//WENN EINGELOGGT
{
	if(!$suchwert && !$suchen_alles) //WENN KEIN SUCHWERT UND OPTION 'ALLES' NICHT GESETZT SIND
  {
   	echo "Kein Suchwert angegeben !</b></font><hr>";
  }
  elseif((!$suchwert && $suchen_alles) || ($suchwert && $suchen_alles)) //WENN 'ALLES' GESETZT WIRD, EGAL OB SUCHWERT ODER NICHT
  {
  	$gesamt = all_dir_files (".",$ausgabe=false);
  	echo "Alles</td></tr><tr><td align=\"left\" valign=\"middle\"><b>Treffer:&nbsp;&nbsp;$gesamt</b></font></td></tr></table><br>";
    all_dir_files (".",$ausgabe=true);					//ALLES AUFLISTEN
  }
  else		//SONST
  {                            
  	//WENN DIE AUSGABE DER VERZEICHNISLISTE IN core.schnufflodondron.php DEAKTIVIERT WURDE, MU DER AUSGANGSWERT IN DER
  	//VARIABLEN $verzeichnisliste UNBEDINGT NEU GESETZT WRDEN; SONST KANN DIE SUCHE NICHT DURCHGEFHRT WERDEN
  	if(!$verzeichnisliste)
  	{
  		$verzeichnisliste = "alle";
  	}
  	
  	//ABFRAGEN, OB IN ALLEN VERZEICHNISSEN ODER IM AUSGEWHLTEN VERZEICHNIS GESUCHT WERDEN SOLL
  	if($verzeichnisliste == "alle")
  	{  
	    $treffer = search_dir_files(".",$suchwert,$zeilen,$zeichen,$nur_fundstellen,$ausgabe=false);	//NACH SUCHWERT SUCHEN UND TREFFERANZAHL ERMITTELN
	    echo "$suchwert</td></tr><tr><td align=\"left\" valign=\"middle\"><b>Treffer:&nbsp;&nbsp;$treffer</b></font></td></tr></table><br>";   //TREFFER IM KOPF AUSGEBEN
	    search_dir_files(".",$suchwert,$zeilen,$zeichen,$nur_fundstellen,$ausgabe=true); //NACH SUCHWERT SUCHEN UND AUSGEBEN
	  }
	  else
	  {  
	   	$suchpfad = getcwd();
	   	$dir = strrchr($suchpfad,"/");
	   	$verzeichnisliste = stristr($verzeichnisliste, $SERVER_NAME);  //RCKGABE AB SERVERNAME
	   	$verzeichnisliste = strchr($verzeichnisliste, "/");            //RCKGABE AB ERSTEN /
	   	$verzeichnisliste = ereg_replace($dir, ".",$verzeichnisliste); //ROOTVERZEICHNIS MIT . ERSETZEN -> VORHER ROOTVERZEICHNIS/UNTERVERZEICHNIS - NACHHER ./UNTERVERZEICHNIS -> . ist ROOT VERZEICHNIS
	   	//echo "$verzeichnisliste<br>";	    //KONTROLLE
	    $treffer = @search_dir_files($verzeichnisliste,$suchwert,$zeilen,$zeichen,$nur_fundstellen,$ausgabe=false);	//NACH SUCHWERT SUCHEN UND TREFFERANZAHL ERMITTELN
	    echo "$suchwert</td></tr>";
	    echo "<tr><td align=\"left\" valign=\"middle\"><b>in:&nbsp;&nbsp;$verzeichnisliste</b></td></tr>";
	    echo "<tr><td align=\"left\" valign=\"middle\"><b>Treffer:&nbsp;&nbsp;$treffer</b></font></td></tr></table><br>";   //TREFFER IM KOPF AUSGEBEN
	    search_dir_files($verzeichnisliste,$suchwert,$zeilen,$zeichen,$nur_fundstellen,$ausgabe=true); //NACH SUCHWERT SUCHEN UND AUSGEBEN
	  }
  }

}

//FU HTML-SCHREIBEN
echo <<<FUSS
		</font>
	</body>
	</html>
FUSS;
?>
