<?php
/**********************************************************************************************
~ AUTOR UND MAINTAINER: Andreas Theusner,  2003 - ansatheus@gmx.net - http://www.ansatheus.de
~ WEITERE BEARBEITER: Kay Dittmann - kay.dittmann@freenet.de
~ PROGRAMM: AT Contenator
~ DATEI: core.parser.php
~ ZWECK: enthlt den Parser zur Darstellung der Inhalte in den content.-Dateien
/**********************************************************************************************
~	VERWENDUNG:			z.B. fr Handbcher, Dokumentationen oder hnliches
~	FUNKTIONALITT:	- es wird zwischen Verzeichnissen und Dateien unterschieden
~									- es werden alle eingestellten Dokumenttypen im Ausgangsverzeichnis
~										aufsteigend sortiert ausgegeben
~									- jeder geparste Dokumenten-Eintrag wird als link generiert
~									- es wird untersucht, ob der Aufruf der index.php
~										per Webbrowser von einem Server (z.B. Apache) aufgerufen
~										wird oder lokal mit einem entsprechendem Tool (z.B. Zend IDE)
~										generiert und dann gestartet wird bzw. als HTML-Datei dort
~										abgespeichert wird
~									- Ausgangspunkt fr das Generieren ist immer das aktuelle Verzeichnis,
~                   indem diese Datei liegt
~                 - einlesen einer im selben Verzeichnis liegenden Textdatei mit Inhalten
~                   (content.-Dateien) und formatierte Ausgabe
~	AUFRUF:					- Browser: Servername/Verzeichnisname/parser.php
~                 - wird bei Einsatz des Menugenerator automatisch aufgerufen, sobald ein
~                   Menpunkt angewhlt wird
~ HINWEISE:				alle Verzeichnisse und Dateien mssen im Verzeichnis von index.php liegen
~ STATUS:					einsatzfhig
~ HINWEIS:        detaillierte Kommentare befinden sich im Quellcode
**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

//INCLUDE - $pfad WIRD REKURSIV IN DER JEWEILIGEN index.php FR VERZEICHNISAUFRUF ERZEUGT
require_once($pfad."core.config.php");
require_once("core.parser_functions.php");

// ****************************** <geaendert Kay Dittmann> ************************************
$tagzeile= 0;
include($pfad."core.newtag.php");
// ***************************** </geaendert Kay Dittmann> ************************************

/**********************************************************************************************
*           INITIALISIERUNGEN
**********************************************************************************************/
$ubr = "<br>"; //ZEILENUMBRUCH NACH BENUTZERDEFINIERTEN BERSCHRIFTEN
$postp = "<p>"; //ABSATZ NACH BENUTZERDEFINIERTEN BERSCHRIFTEN

//EINRCKUNGSMODUS ABFRAGEN
$indentline = config_read("indentline",$pfad."_config");  //KONFIGURATION FR LINKINDEX HOLEN

//ICONPFAD ABFRAGEN
$iconpfad = config_read("iconpfad",$pfad."_config");  //KONFIGURATION FR ICONS HOLEN

//-----
//DEBUGMODUS ABFRAGEN UND WENN, DRAUF HINWEISEN
$debug = config_read("debug",$pfad."_config");  //KONFIGURATION FR DEBUG HOLEN
//-----

//WYSIWYG-EDITOR TINYMCE
$tinymce = config_read("tinymce",$pfad."_config");  //KONFIGURATION FR TINYMCE HOLEN

//FRAMESET HOLEN
$frameset = config_read("frameset",$pfad."_config");  //KONFIGURATION FR FRAMESET HOLEN

//WENN EINRCKUNGSMODUS on SIND NUR BEGRENZTE ZEILENLNGEN ZULSSIG, DA LEERZEICHEN UND
//ZEILENUMBRCHE MIT GENERIERT WERDEN. DAS GIBT BEI ZU LANGEN TEXTEN ODER VERKLEINERUNG
//DES BROWSERFENSTERS UNSCHNE ZEILENUMBRCHE
if(chop($indentline) == "on")
{
  $nbsp = "&nbsp;&nbsp;";  //LEERZEICHEN
  $br = "<br>";            //ZEILENUMBRUCH FR NORMALEN TEXT
  $prep = "";              //ABSATZ VOR BENUTZERDEFINIERTEN BERSCHRIFTEN
}
else
{
  $nbsp = "";
  $br = "";
  $prep = "<p>";
}

if(chop($tinymce) == "on")
{
  $tinybr = "";
}
else
{
  $tinybr = $br;
}

/**********************************************************************************************
*           FUNKTIONEN
**********************************************************************************************/

/*******************************************************************************************
~ NAME: function count_files_dirs ($dir)
~ ART: php-Script
~ ZWECK: rekursives Auslesen aller Dateien und Verzeichnisse ab Startverzeichnis
~        zur Ermittlung der Anzahl der Dateien - Statistik (wenn eingesetzt)
~ FUNKTIONALITT:
~		$dir = Startverzeichnis - alle Verzeichnisse darunter werden rekursiv durchsucht
~		$fp = Handle 
~ AUFRUF:	count_files_dirs(".");
~ STATUS: Funktion wird nicht standardmig genutzt
*******************************************************************************************/
//GLOBALE VARIABLEN SETZEN UND INITIALISIEREN FR STATISTIK (WENN EINGESETZT) - GEHRT ZU NACHFOLGENDER FUNKTION
$filecounter = 0; 
$dircounter = 0;

function count_files_dirs ($dir) 
{ 
	global $filecounter; 
	global $dircounter;
	
	$fp=opendir($dir);               				//VERZEICHNIS FFNEN
	
	while($datei=readdir($fp))       				//JEDEN EINTRAG DURCHLAUFEN
	{ 
		if (is_dir("$dir/$datei") && $datei!="." && $datei!=".." && (substr($datei,0,1) != "_"))  //WENN Verzeichnis DANN . UND .. AUSSCHLIEEN
		{ 
			count_files_dirs ("$dir/$datei");  	//WENN VERZEICHNIS REKURSIVER AUFRUF
			$dircounter++;                     	//VERZEICHNISCOUNTER HOCHZHLEN
		} 
		else                                  //SONST NUR
		{
		  if ($datei!="." && $datei!=".." && !preg_match("/.php/",$datei) && (substr($datei,0,1) != "_")
         && !preg_match("/core/",$datei) && !preg_match("/modul/",$datei) && !preg_match("/install/",$datei)
         && !preg_match("/index/",$datei) && !preg_match("/config/",$datei) && !preg_match("/content/",$datei))    //NUR . UND .. UND PHP-DATEIEN AUSSCHLIEEN
		  {
			  $filecounter++;                   //DATEICOUNTER HOCHZHLEN
		  }
		} 
	}
	 
	closedir($fp);                         	//VERZEICHNIS SCHLIEEN
}


/*******************************************************************************************
~ NAME: function parsen_inline($textzeile,$leerzeichen,$br)
~ ART: php-Script
~ ZWECK: parst eine eingelesene Textzeile nach vorkommen von Steuerzeichen innerhalb des
~        Textes, ersetzt den entsprechenden Teil und gibt die modifizierte Textzeile zurck
~ AUFRUF:	$var = parsen_inline($textzeile,$leerzeichen,$br);
~ STATUS: Funktion kann anjeder Stelle eingesetzt werden
~ PARAMETER: $textzeile = die aktuell durchlaufende Textzeile im Array
~            $leerzeichen = Anzahl von &nbsp; -> Leerzeichen in HTML
~						 $br = Zeilenumbruch
~               $leerzeichen und $br knnen auch HTML-Tags bergeben werden
~               Bsp.: parsen_inline($textzeile,"<font color=red>","</font>")
~                  Rckgabe = <font color=red>gesuchter Text</font>
*******************************************************************************************/
function parsen_inline($iv,$nbsp="&nbsp;&nbsp;",$br="<br>")
{	//echo "FUNKTIONSDUMP "; var_dump($iv); echo "<br>";
	global $pfad; //VARIABLE FR DYNAMISCH ERZEUGTEN PFAD IMPORTIEREN
	global $debug; //DEBUGMODUS
	
	//LINKS IM TEXT PARSEN
	$anfang = strpos($iv,"^"); //UNTERSUCHEN, OB BERHAUPT LINKS GESETZT SIND
	if(isset($anfang)) { $parsen = true; } //WENN, DANN PARSEN - ISSET HIER DESHALB, WEIL DIE ERSTE PSOITION
																				 //AUCH 0 SEIN KANN UND DAS FALSE (BOOLEAN) IST -> ISSET IGNORIERT DAS
	if($parsen) //WENN GEPARST WERDEN SOLLE
	{	
		$a = 0;  //ARRAYCOUNTER
		//GESAMTE ZEILE DURCHLAUFEN
		for($i=0;$i<=strlen($iv);$i++)
		{ 
			if($iv[$i] == "^")        //WENN ERSTES STEUERZEICHEN
			{ 
				if($steuerzeichen == false)  //WENN FALSE (ALSO KEINES GEFUNDEN ODER WIEDER GESCHLOSSEN)
				{
					$steuerzeichen = 1;     //AUF TRUE SETZEN (WENN ERSTES, FFNENDES STEUERZEICHEN)  
				}
				else
				{
					$steuerzeichen = 0;     //SONST FALSE (WENN ZWEITES, SCHLIEENDES STEUERZEICHEN)
					$a++;                   //ARRAYCOUNTER HOCHZHLEN
				}
			}                        
													
			//WENN FFNENDES STEUERZEICHEN
			if($steuerzeichen == 1)
			{
				$zeilenpuffer[$a] .=  $iv[$i]; //ZEICHEN IN ARRAY
			}
		}                                          
		//echo "ZEILENPUFFER: " .var_dump($zeilenpuffer); echo "<br>";
		//zeilenpuffer AUSWERTEN 
		if(is_array($zeilenpuffer))
		{
			foreach($zeilenpuffer as $value) //WEITER - OFFENSICHTLICH LUFT DAS ARRAY NUR 2x ?-> NUR ZWEI FORMATIERTE ZEILEN WERDEN AUSGEGEBEN
			{ //var_dump($zeilenpuffer);
			  //echo "<br>$value<br>";  //AT-DEBUG
				//echo $i++ . "<br>";
				switch(substr($value,0,2))
				{ 
					case "^":	switch(substr($value,0,3))
											{
												case "^/": $iv = str_replace($value."^","<b><i>".substr($value,3,strlen($value))."</i></b>",$iv); break;//FETT UND KURSIV FORMATIEREN
												case "^_": $iv = str_replace($value."^","<b><u>".substr($value,3,strlen($value))."</u></b>",$iv); break;//FETT UND UNTERSTRICHEN FORMATIEREN
												case "^0": $iv = str_replace($value."^","<b><font color=\"#000000\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE black FETT
												case "^1": $iv = str_replace($value."^","<b><font color=\"#FFFFFF\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE white FETT
												case "^2": $iv = str_replace($value."^","<b><font color=\"#FFFF00\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE yellow FETT
												case "^3": $iv = str_replace($value."^","<b><font color=\"#FF0000\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE red FETT
												case "^4": $iv = str_replace($value."^","<b><font color=\"#0000FF\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE blue FETT
												case "^5": $iv = str_replace($value."^","<b><font color=\"#000080\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE navy FETT
												case "^6": $iv = str_replace($value."^","<b><font color=\"#008000\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE green FETT
												case "^7": $iv = str_replace($value."^","<b><font color=\"#00FFFF\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE aqua FETT
												case "^8": $iv = str_replace($value."^","<b><font color=\"#00FF00\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE lime FETT
												case "^9": $iv = str_replace($value."^","<b><font color=\"#C0C0C0\">".substr($value,3,strlen($value))."</font></b>",$iv); break;//TEXTFARBE silver FETT
												default: $iv = str_replace($value."^","<b>".substr($value,2,strlen($value))."</b>",$iv); //STANDARDMIG FETT FORMATIEREN
																 break;
											}
											break;
					case "^/":  switch(substr($value,0,3))
											{
												case "^/": $iv = str_replace($value."^","<b><i>".substr($value,3,strlen($value))."</i></b>",$iv); break;//KURSIV UND FETT FORMATIEREN
												case "^/_": $iv = str_replace($value."^","<i><u>".substr($value,3,strlen($value))."</u></i>",$iv); break;//KURSIV UND UNTERSTRICHEN FORMATIEREN
												case "^/0": $iv = str_replace($value."^","<i><font color=\"#000000\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE black KURSIV
												case "^/1": $iv = str_replace($value."^","<i><font color=\"#FFFFFF\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE white KURSIV
												case "^/2": $iv = str_replace($value."^","<i><font color=\"#FFFF00\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE yellow KURSIV
												case "^/3": $iv = str_replace($value."^","<i><font color=\"#FF0000\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE red KURSIV
												case "^/4": $iv = str_replace($value."^","<i><font color=\"#0000FF\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE blue KURSIV
												case "^/5": $iv = str_replace($value."^","<i><font color=\"#000080\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE navy KURSIV
												case "^/6": $iv = str_replace($value."^","<i><font color=\"#008000\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE green KURSIV
												case "^/7": $iv = str_replace($value."^","<i><font color=\"#00FFFF\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE aqua KURSIV
												case "^/8": $iv = str_replace($value."^","<i><font color=\"#00FF00\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE lime KURSIV
												case "^/9": $iv = str_replace($value."^","<i><font color=\"#C0C0C0\">".substr($value,3,strlen($value))."</font></i>",$iv); break;//TEXTFARBE silver KURSIV	
												default: $iv = str_replace($value."^","<i>".substr($value,2,strlen($value))."</i>",$iv); //KURSIV FORMATIEREN	
																 break;
											}
											break;
					case "^_":	switch(substr($value,0,3))
											{
												case "^_0": $iv = str_replace($value."^","<u><font color=\"#000000\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE black UNTERSTRICHEN 
												case "^_1": $iv = str_replace($value."^","<u><font color=\"#FFFFFF\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE white UNTERSTRICHEN 
												case "^_2": $iv = str_replace($value."^","<u><font color=\"#FFFF00\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE yellow UNTERSTRICHEN 
												case "^_3": $iv = str_replace($value."^","<u><font color=\"#FF0000\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE red UNTERSTRICHEN 
												case "^_4": $iv = str_replace($value."^","<u><font color=\"#0000FF\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE blue UNTERSTRICHEN 
												case "^_5": $iv = str_replace($value."^","<u><font color=\"#000080\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE navy UNTERSTRICHEN 
												case "^_6": $iv = str_replace($value."^","<u><font color=\"#008000\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE green UNTERSTRICHEN 
												case "^_7": $iv = str_replace($value."^","<u><font color=\"#00FFFF\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE aqua UNTERSTRICHEN 
												case "^_8": $iv = str_replace($value."^","<u><font color=\"#00FF00\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE lime UNTERSTRICHEN 
												case "^_9": $iv = str_replace($value."^","<u><font color=\"#C0C0C0\">".substr($value,3,strlen($value))."</font></u>",$iv); break;//TEXTFARBE silver UNTERSTRICHEN 	
												default: $iv = str_replace($value."^","<u>".substr($value,2,strlen($value))."</u>",$iv); //UNTERSTRICHEN FORMATIEREN
													  		 break;
											}
											break;
					case "^&":  switch(substr($value,0,3))
											{
												case "^&0": $iv = str_replace($value."^","<font color=\"#000000\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE black
												case "^&1": $iv = str_replace($value."^","<font color=\"#FFFFFF\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE white
												case "^&2": $iv = str_replace($value."^","<font color=\"#FFFF00\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE yellow
												case "^&3": $iv = str_replace($value."^","<font color=\"#FF0000\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE red
												case "^&4": $iv = str_replace($value."^","<font color=\"#0000FF\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE blue
												case "^&5": $iv = str_replace($value."^","<font color=\"#000080\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE navy
												case "^&6": $iv = str_replace($value."^","<font color=\"#008000\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE green
												case "^&7": $iv = str_replace($value."^","<font color=\"#00FFFF\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE aqua
												case "^&8": $iv = str_replace($value."^","<font color=\"#00FF00\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE lime
												case "^&9": $iv = str_replace($value."^","<font color=\"#C0C0C0\">".substr($value,3,strlen($value))."</font>",$iv); break;//TEXTFARBE silver
												default: $iv = str_replace($value."^",substr($value,2,strlen($value)),$iv); //STANDARDMIG MIT FARBE IN CSS-DATEI FORMATIEREN
																 break;
											}
											break;
					case "^;":	switch(substr($value,0,3))
											{
												case "^;0": $iv = str_replace($value."^","<span style=\"background-color:#000000\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE black
												case "^;1": $iv = str_replace($value."^","<span style=\"background-color:#FFFFFF\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE white
												case "^;2": $iv = str_replace($value."^","<span style=\"background-color:#FFFF00\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE yellow
												case "^;3": $iv = str_replace($value."^","<span style=\"background-color:#FF0000\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE red
												case "^;4": $iv = str_replace($value."^","<span style=\"background-color:#0000FF\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE blue
												case "^;5": $iv = str_replace($value."^","<span style=\"background-color:#000080\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE navy
												case "^;6": $iv = str_replace($value."^","<span style=\"background-color:#008000\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE green
												case "^;7": $iv = str_replace($value."^","<span style=\"background-color:#00FFFF\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE aqua
												case "^;8": $iv = str_replace($value."^","<span style=\"background-color:#00FF00\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE lime
												case "^;9": $iv = str_replace($value."^","<span style=\"background-color:#C0C0C0\">".substr($value,3,strlen($value))."</span>",$iv); break;//HINTERGRUNDFARBE silver
												default: $iv = str_replace($value."^",substr($value,2,strlen($value)),$iv); //STANDARDMIG MIT HINTERGRUNDFARBE IN CSS-DATEI FORMATIEREN
																 break;
											}
											break;
					case "^~":	$iv = str_replace($value."^","<img src=\"".substr($value,2,strlen($value))."\" border=\"0\" alt=\"".substr($value,2,strlen($value))."\">",$iv); //BILD EINFGEN
											break;
					case "^@":	$bildarray = explode("@@",$value);  //STRING IN ARRAY AUFTEILEN
											$iv = str_replace($value."^","<a href=\"".substr($bildarray[1],0,strlen($bildarray[1]))."\" target=\"_blank\"><img src=\"".substr($bildarray[0],2)."\" border=\"0\" alt=\"".substr($bildarray[1],0)."\"></a>",$iv); //BILDLINK
											break;
					case "^\\": $iv = str_replace("^\\","^",$iv); //ESCAPEN FR DARSTELLUNG DER STEUERZEICHEN
											break;
					case "^|":  switch(substr($value,0,3))
					            {
					              case "^||": $iv = str_replace($value."^", "<p>",$iv); break; //ABSATZ
                        default: $iv = str_replace($value."^", "<br>",$iv); //ZEILENUMBRUCH
                                 break;
                      }
					            break;
          case "^":  $linkarrayinsert = explode("@@",$value); //LINK IM SELBEN FENSTER FFNEN - STEUERZEICHNE IST SELBE TASTE WIE ZIRKUMFLEX, NUR MITTELS UMSCHALTTASTE
                      switch(count($linkarrayinsert))    //ANZAHL DER ARRAYELEMENTE UNTERSUCHEN
									    {
                         case 1: $suchstringinsert = $linkarrayinsert[0]."^";  //SUCHSTRING BAUEN
														     $linkswitchinsert = config_read(substr($linkarrayinsert[0],2),$pfad."_config","core.linkswitch.dat","==");  //LINK DER LINKID HOLEN
														     $linkswitchinsert = chop($linkswitchinsert);  //LEERZEICHEN ENTFERNEN
														     $iv = str_replace($suchstringinsert,"<a href=\"$linkswitchinsert\">&nbsp;" . substr($linkarrayinsert[0],2) . "&nbsp;</a>",$iv); //TEXT DURCH KOMPLETTEN LINK ERSETZEN
														     break;			
										     case 2: $suchstringinsert = $linkarrayinsert[0]. "@@" .$linkarrayinsert[1]."^";	 //SUCHSTRING BAUEN
														     $iv = str_replace($suchstringinsert,"<a href=\"$linkarrayinsert[1]\">&nbsp;" . substr($linkarrayinsert[0],2) . "&nbsp;</a>",$iv);  //TEXT DURCH KOMPLETTEN LINK ERSETZEN
														     break;
										     default: break;
									    }
                      break;
					//SONST LINK ERZEUGEN
					default:$linkarray = explode("@@",$value);  //STRING IN ARRAY AUFTEILEN
																		
									switch(count($linkarray))    //ANZAHL DER ARRAYELEMENTE UNTERSUCHEN
									{ //LINK AUS DER LINKLISTE PER LINKID (AUTOMATSICH, WENN KEINE ADRESSE IM TEXT ANGEGEBEN IST)
										case 1: $suchstring = $linkarray[0]."^";  //SUCHSTRING BAUEN
														$linkswitch = config_read(substr($linkarray[0],1),$pfad."_config","core.linkswitch.dat","==");  //LINK DER LINKID HOLEN  
														$linkswitch = chop($linkswitch);  //LEERZEICHEN ENTFERNEN
														$iv = str_replace($suchstring,"<a href=\"$linkswitch\" target=\"_blank\">&nbsp;" . substr($linkarray[0],1) . "&nbsp;</a>",$iv); //TEXT DURCH KOMPLETTEN LINK ERSETZEN
														break;
										//LINK, WENN LINKADRESSE ANGEGEBEN IST				
										case 2: $suchstring = $linkarray[0]. "@@" .$linkarray[1]."^";	 //SUCHSTRING BAUEN
														$iv = str_replace($suchstring,"<a href=\"$linkarray[1]\" target=\"_blank\">&nbsp;" . substr($linkarray[0],1) . "&nbsp;</a>",$iv);  //TEXT DURCH KOMPLETTEN LINK ERSETZEN
														break;   
										default: break; 
									}
									break;
				}
			}
		}
			$iv = str_replace("\\^","^",$iv); //LETZTES ESCAPEZEICHEN ERSETZEN 
			return $nbsp.$iv.$br; //ENDGLTIGE AUSGABE ALS RCKGABEWERT - <br> AUCH HIER, WEIL $iv IMMER EINE ZEILE REPRSENTIERT
	}	
	else
	{	
		//NORMALE AUSGABE - WENN KEINE STEUERZEICHEN MITTEN IM TEXT SIND ALS RCKGABEWERT
		return $nbsp.$iv.$br;  // <br> AUCH HIER, WEIL $iv IMMER EINE ZEILE REPRSENTIERT
	}
	unset($zeilenpuffer);
}
	
/*******************************************************************************************
*           HAUPTPROGRAMM
*******************************************************************************************/
$stylepfad = config_read("stylepfad",$pfad."_config");  //KONFIGURATION FR STYLE HOLEN
$stylepfad = chop($stylepfad);													//LEERZEICHEN UND SONDERZEICHEN ENTFERNEN

$server = $SERVER_NAME;												//HOLT DEN SERVERNAME 
$local = getcwd();														//HOLT DEN PFAD FR DAS AKTUELLE VERZEICHNIS 

//WENN $serverroot NICHT GESETZT IST, MU HIER DER PHYSISCHE PFAD DES ROOTVERZEICHNISSES (DocumentRoot IN APACHE) DES WEBSERVERS STEHEN
//DIESER PFAD MU IDENTISCH SEIN MIT DEM PARAMETERWERT VON $root IN DER FUNKTION print_link IN DER menu.php
//BEIDE PFADE MSSEN BEI EINRICHTUNG AUF EINEM SERVER ENTSPRECHEND ANGEPAT WERDEN
//ZWECK: AUSGABE DER POSITION IN DER HINWEISZEILE IM DOKUMENT
if(!$serverroot)
{
  $serverroot = config_read("serverpfad",$pfad."/_config");      //KONFIGURATION HOLEN
}

$drive = "";																	//INIT
$unterverzeichnispfad = config_read("unterverzeichnispfad",$pfad."/_config"); //WENN ROOTVERZEICHNIS AB 2. UNTERVERZEICHNIS VOM SERVERROOT IST,
																							//  MU DER PFAD AB 2. UNTERVERZEICHNIS HIER GESETZT WERDEN	- OFFENBAR NICHT IMMER NOTWENDIG
//-----------------------------

//BERSCHRIFT SETZEN
if($server)																		//WENN VARIABLE INHALT HAT - AUFRUF PER WEBBROWSER
{
  if(chop($serverroot) > "")                  //WENN KEINE serverpfad IN core.cinfig.dat GESETZT IST
  {
	  $replacestring = chop($serverroot);       //NICHT SICHTBARE ZEICHEN AM ENDE ENTFERNEN
	  $serverroot = ereg_replace("($replacestring)","http://" . $SERVER_NAME,$local);   //SERVERPFAD MIT WEBPFAD ERSETZEN
	}                            //BEGRENZUNGSZEICHEN DRFEN NICHT IM STRING AUFTAUCHEN (z.B. /) , DESHALB HIER KLAMMERN
	else
	{
	  $serverroot = $local;                       //PHYSIKALISCHEN PFAD SETZEN
	}
}
else																					//SONST - AUFRUF LOKAL (WENN DATEI index.htm ERZEUGT)
{
	$root = $local;															//AKTUELLES VERZEICHNIS ALS ROOT SETZEN
	$drive = $local;														//VERZEICHNISPFAD ZUSAMMENBAUEN
}

//######################################################################################################
if(!isset($content_other_file))  //NICHT BEI DATEIEN IM ERWEITERTEM FRAMESET
{
  //LINKINDEX GENERIEREN - ANFANG
  $linkindex = config_read("linkindex",$pfad."_config");  //KONFIGURATION FR LINKINDEX HOLEN

  //WENN LINKINDEX AUF on
  if(chop($linkindex) == "on")  //IF LINKINDEX on/off
  {
    $dateiarten = config_read("dateiarten",$pfad."/_config");      //KONFIGURATION FR LINKDATEIEN HOLEN
                                                                 //$pfad WIRD AUTOMATISCH ZUSAMMENGEBAUT IN index.php
    $dateiarten = explode(";",$dateiarten);                        //DATEIARTEN AUFSPLITTEN

    $dateiignore = config_read("dateiignore",$pfad."/_config");    //KONFIGURATION FR AUSZUSCHLIEENDE DATEIEN HOLEN
    $dateiignore = explode(";",$dateiignore);                      //DATEIARTEN AUFSPALTEN

    $verz=opendir(".");                           //AKTUELLES VERZEICHNIS ALS AUSGANGSPUNKT SETZEN

    while ($file = readdir ($verz)) 							//JEDEN EINTRAG LESEN
    {
   	  if($file != '.' and $file != '..' 				//WERTE . UND .. UND index.php UND index.htm UND index.html AUSSCHLIEEN
		  	and !preg_match("/.php/",$file)
			  and !preg_match("/index/",$file)
			  and !preg_match("/core/",$file)
			  and !preg_match("/modul/",$file)
			  and !preg_match("/install/",$file)
			  and !preg_match("/config/",$file)
			  and !preg_match("/content./",$file)
			  and @!dir($file)) //AUCH WENN $file EIN VERZEICHNIS IST
		  {
		
			  //DATEIEN FR LINKLISTE PUFFERN
			  $linklist[] = $file;
		  }
    }

    closedir($verz); 															//VERZEICHNIS SCHLIESSEN
    //-----------------------------------------------------------------------------
    //DATEIEN IN $dateiignore AUS $linklist RAUSSCHMEIDEN
    if(is_array($linklist))  //IF is_array
    {
      foreach($linklist as $klist => $vlist)   //DATEIEN FR LINKS DURCHLAUFEN
      {
        foreach($dateiignore as $ki => $vi)    //AUSZUSCHLIESSENDE DATEIEN DURCHLAUFEN
        {
          if(preg_match("/$vi/",$vlist))       //WENN AUSZUSCHLIESSENDE DATEI IN LINKLISTE ENTHALTEN IST
          {
            unset($linklist[$klist]);          //DATEI AUS LINKLISTE LSCHEN
          }
        }
      }

      $linklist = array_values($linklist);     //NEUEN, LCKENLOSEN INDEX ERZEUGEN

      //-----------------------------------------------------------------------------
      //FOREACH 2
      foreach($linklist as $vlink)             //DATEIEN FR LINKS ERNEUT DURCHLAUFEN
      {
        foreach($dateiarten as $vmatch)        //DOWNLOADBARE DATEIARTEN DURCHLAUFEN
        {
          if(preg_match("/$vmatch/",$vlink))   //WENN DOWNLOADBARE DATEIART ENTHALTEN IST
          {
            $pufferfile[$vlink] = "<font size=1><a href=\"$vlink\" target=\"_blank\">&nbsp;$vlink&nbsp;</a></font>\n<br>";  //LINK GENERIEREN UND IN ARRAY SCHREIBEN
          }
        }
      } //FOREACH 2
    } //IF is_array
  } //IF LINKINDEX on/off
  //LINKINDEX GENERIEREN - ENDE
} //$content_other_file
//######################################################################################################

//CSS-DATEIEN UND CONTENTDATEIEN ZUORDNEN UND EINLESEN, UNTERSUCHEN UND FORMATIERT AUSGEBEN
if(isset($content_other_file)) //WENN VARIABLE GESETZT IST UND INHALT HAT -> WERDEN NUR IN DEN EINZELNEN FRAMEDATEIEN FR ERWEITERTEN FRAMESET GESETZT
{
  $content_other_file = explode("|",$content_other_file); //CONTENDATEI UND ZUGEORDNETE CSS-DATEI EXTRAHIEREN

  switch($content_other_file[0])  //CONTENTDATEIEN ZUORDNEN
  {
    case "content.frame_top.txt" :    $contentfile = $content_other_file[0]; //INHALTSDATEI ZUORDNEN
                                      $css = $pfad . $stylepfad . "/" . $content_other_file[1]; //CSS-DATEI ZUORDNEN
                                      $contentframe = contentframe($contentfile,$frameset);  //ZUORDNUNG DER FRAMES FR DIE BEARBEITUNG
                                      break;
    case "content.frame_bottom.txt" : $contentfile = $content_other_file[0];
                                      $css = $pfad . $stylepfad . "/" . $content_other_file[1];
                                      $contentframe = contentframe($contentfile,$frameset);
                                      break;
    case "content.frame_right.txt" :  $contentfile = $content_other_file[0];
                                      $css = $pfad . $stylepfad . "/" . $content_other_file[1];
                                      $contentframe = contentframe($contentfile,$frameset);
                                      break;
    default: if(!$contentfile)
             {
               $contentfile = $content_other_file[0];  //ANDERE CONTENTDATEI PER LINK ZUZULASSEN
                                                       //BSP: pfad/zu/contenatorroot/core.parser.php?content_other_file=1&contentfile=pfad/zu/content_other.txt
                                                       //HIERBEI MU content_other_file GESETZT WERDEN UND JEWEILS DER KOMPLETTE PFAD ANGEGEBEN WERDEN
                                                       //ANDERE VARIANTE, WENN INNERHALB EINES VERZEICHNIS EINE ANDERE DATEI ZUGELASSEN WERDEN SOLL
                                                       //index.php?includeseite=core.parser.php&level=0&content_other_file=content_mehr.txt&pfad=../
                                                       //WENN $content_other_file = "content_other.txt|style.css"; IN index.php SO GESETZT IST,
                                                       //DANN WIRD IN DIE IF-ABFRAGE GEGANGEN, IN DER OBEREN VARIANTE NICHT
             }
             
             $css = $pfad . $stylepfad . "/verzeichnis.index.css";
             $contentframe = contentframe($contentfile,$frameset);
             break;
  }
}
else //SONST BLEIBT ALLES BEIM ALTEN
{
  $contentfile = "content.txt";
  $css = $pfad . $stylepfad . "/verzeichnis.index.css";
  $contentframe = contentframe($contentfile,$frameset);
} //$content_other_file

//JAVASCRIPT
$js = $pfad . "_js/";

//WENN EIN SOFTLINK-VERZEICHNIS UNTER UNIX/LINUX DURCHLAUFEN WERDEN SOLL
//WIRD IN DER SEPARATEN index.php DAFR EINGESTELLT
if($symlink)
{
  $css = $sympfad . $stylepfad . "/verzeichnis.index.css";

  //NEU
  $js = $sympfad . "_js/";
}

$contentdaten = @file($contentfile); //DATEI IN ARRAY EINLESEN



//########################################################################################################################################
if(!isset($content_other_file))  //NICHT BEI DATEIEN IM ERWEITERTEM FRAMESET
{
  //STATISTIK-PARSER - ANFANG
  $statistikparser = config_read("statistikparser",$pfad."_config");  //KONFIGURATION FR STATISTIKPARSER HOLEN

  //WENN STATISTIKPARSER AUF on
  if(chop($statistikparser) == "on")  //IF STATISTIKPARSER on/off
  {
    //STATISTIK-PARSER - ANFANG
    //STATISTIKEN: SEITENBERSCHRIFT, STATISTIK
    if(is_array($contentdaten)) //IF 0
    {
      foreach($contentdaten as $titel_statistik)  //FOREACH
      {
  	    //UMLAUTE UND SONDERZEICHEN KONVERTIEREN
  	    $titel_statistik = str_replace("","&Auml;",$titel_statistik);
	      $titel_statistik = str_replace("","&auml;",$titel_statistik);
	      $titel_statistik = str_replace("","&Ouml;",$titel_statistik);
	      $titel_statistik = str_replace("","&ouml;",$titel_statistik);
	      $titel_statistik = str_replace("","&Uuml;",$titel_statistik);
	      $titel_statistik = str_replace("","&uuml;",$titel_statistik);
	      $titel_statistik = str_replace("","&szlig;",$titel_statistik);
	
        if(substr($titel_statistik,0,1) == "~")     //IF 1 - WENN GEFUNDEN - BERSCHRIFT IN KOPFZEILE
        {
    	    //-----------------------------------------------------------------
          if(substr($titel_statistik,0,2) == "~~")  //IF 2.1 - WENN EBENFALLS GEFUNDEN - DATEIEN-VERZEICHNISSE ZHLEN
          {
            $dateien_verzeichnisse_count = true;                   //DATEIEN UND VERZEICHNISSE ZHLEN AN
          }   //IF 2.1
          //-----------------------------------------------------------------
          elseif(substr($titel_statistik,0,2) == "~")  //ELSEIF 2.2 - ERSTELLER
          {
       	    $copyright = "<b>Ersteller:</b> " . substr($titel_statistik,2);  //ERSTELLER DER DATEI
          } //ELSEIF 2.2
          //-----------------------------------------------------------------
          elseif(substr($titel_statistik,0,2) == "~?")  //ELSEIF 2.3 - LETZTE BEARBEITUNG
          {
      	    $zeit = filemtime("content.txt");
       	    //$letzte_bearbeitung = "<b>Letzte Bearbeitung:</b> " . date("d.m.Y - H:i:s", $zeit); //LETZTE NDERUNG DER DATEI
       	    $letzte_bearbeitung = "<b>Letzte Bearbeitung:</b> " . date("d.m.Y", $zeit); //LETZTE NDERUNG DER DATEI
          } //ELSEIF 2.3
          //-----------------------------------------------------------------
          elseif(substr($titel_statistik,0,2) == "~!")  //ELSEIF 2.3 - LETZTE BEARBEITUNG
          {
       	    $seitentitel = substr($titel_statistik,2); //TITEL IM BROWSER
          } //ELSEIF 2.3
          else
          {
            $serverroot = substr($titel_statistik,1);  //BERSCHRIFT IN FARBIGE ZEILE SCHREIBEN
          } //IF 2.1
          //-----------------------------------------------------------------
        } //IF 1
      }  //FOREACH
    } //IF 0

    //-----------------------------------------------------------------
    //STATISTIK
    if($dateien_verzeichnisse_count)
    {
      count_files_dirs("."); //DATEIEN ZHLEN - WENN STATISTIK AKTIVIERT
      $statistik = "<b>Dateien:</b> " . $filecounter . "&nbsp;&nbsp;&nbsp;&nbsp;<b>Verzeichnisse:</b> " . $dircounter; //AUSGABE GEBNERIEREN
    }
  
  } //IF STATISTIKPARSER on/off
  //STATISTIK-PARSER - ENDE
} //$content_other_file
//########################################################################################################################################

$webschnuffel = config_read("webschnuffel",$pfad."_config");  //KONFIGURATION FR FRONTENDANZEIGE HOLEN

//MU AUSGESCHALTET WERDEN, SONST WIRD ES 2x GESCHRIEBEN
if(chop($webschnuffel) == "off")
{
  //NEU
  //JAVASCRIPT
  $js_funktionen = $js . "funktionen.js";

//HTML-KOPF SCHREIBEN
echo <<<KOPF
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html>
		<head>
			<title>$seitentitel</title>
			<meta name="Generator" content="AT Contenator">
      <meta http-equiv="expires" content="0">
      <meta http-equiv="pragma" content="no-cache">
      <meta http-equiv="cache-control" content="no-cache">
      <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
			<link rel="stylesheet" type="text/css" href="$css">
      <script type="text/javascript" src="$js_funktionen"></script> <!--NEU-->
      <script type="text/javascript" src="_js/debug.js"></script>
		</head>
	<body>
KOPF;
}

//DEBUG
$debugausgabe = "$contentfile-$contentframe-$frameset";
//########################################################################################################################################
//HINWEIS AUF DEBUGMODUS
if(chop($debug) == "on")
{
echo <<< OUT
<table border="0" width="100%" cellspacing="1" cellpadding="2">
  <tr bgcolor="yellow">
    <th align="center">
      <font color="red" size="4">DEBUG-MODUS</font>
    </th>
  </tr>
  <tr>
    <td>
        <a href="javascript:" onClick="debugviewer('$tinydatei','$contentfile-$contentframe')">Debugausgabe</a>
        $debugausgabe
    </td>
  </tr>
</table><p>
OUT;
}
//########################################################################################################################################
//BEARBEIUNGSMODUS EINSCHALTEN, WENN VARIABLE BERGEBEN WURDE
if($edit || $GLOBALS["edit"])
{
  $img_edit = $pfad . $iconpfad . "/core.schnufflo_edit.gif";
  $img_tinyedit = $pfad . $iconpfad . "/core.tiny_edit.gif";
  $img_refresh = $pfad . $iconpfad . "/core.refresh.gif";
  $ipfad = $pfad;
  
  //BEI SYMBOLISCHEN LINKVERZEICHNISSEN
  if($symlink)
  {
    $img_edit = $sympfad . $iconpfad . "/core.schnufflo_edit.gif";
  }
  
  $verz=opendir (".");												//AKTUELLES VERZEICHNIS FFNEN

  while ($file = readdir ($verz)) 						//JEDEN EINTRAG LESEN
  {     //echo $file."<br>";
		if(is_file($file))
    {
      if(preg_match("/modul.ordner.onlineedit_advanced.php/",$file))
		  {
			   echo "<a href=\"modul.ordner.onlineedit_advanced.php?contentfile=$contentfile&pfad=$pfad&includeseite=core.parser.php&sympfad=$sympfad\" target=\"_blank\" title=\"Bearbeitung mit OnlineEdit Advanced\"><img src=\"$img_edit\" border=\"0\"></a>";
		  }
		  
		  if(preg_match("/modul.ordner.onlineedit.php/",$file))
		  {
			   echo "<a href=\"modul.ordner.onlineedit.php?contentfile=$contentfile&pfad=$pfad&includeseite=core.parser.php&sympfad=$sympfad\" target=\"_blank\" title=\"Bearbeitung mit OnlineEdit\"><img src=\"$img_edit\" border=\"0\"></a>";
		  }
		}
  }
  
   //$img_edit = $pfad . "core.schnufflo_edit.gif";
   //echo "<a href=\"modul.ordner.onlineedit_advanced.php?contentfile=$contentfile&pfad=$pfad&includeseite=core.parser.php\" target=\"_blank\"><img src=\"$img_edit\"></a>";

  //TINY-MCE
  $tinypfad = $pfad . "core.tinymce.php";
  //EDITOR IN BROWSER
  echo "<a href=\"$tinypfad?contentfile=$contentfile&tinydatei=$tinydatei\" target=\"_blank\" title=\"Bearbeitung mit TinyMCE in neuem Browserfenster\"><img src=\"$img_tinyedit\" border=\"0\"></a>";
  //FR EDITOR IN SEPARATEM JAVASCRIPTFENSTER - OPTION NOCH IN core.config.dat
  echo "<a href=\"javascript:\" onClick=\"editor('$tinypfad','$tinydatei')\"><img src=\"$img_tinyedit\" border=\"0\" title=\"Bearbeitung mit TinyMCE in separatem Fenster\"></a>";
  //FRAME NEU LADEN
  echo "<a href=\"javascript:parent.frames[$contentframe].location.reload()\" target=\"_self\" title=\"Seite neu laden\"><img src=\"$img_refresh\" border=\"0\"></a>";

}
//########################################################################################################################################
//BERSCHRIFT AUSGEBEN
if(!isset($content_other_file))  //NICHT BEI DATEIEN IM ERWEITERTEM FRAMESET
{
echo "<table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"1\">
				<tr><th align=\"center\" valign=\"middle\" class=\"ueberschrift\">
					<font size=\"2\">$serverroot</font>
			</th></tr></table>\n";
}
//########################################################################################################################################
//INHALTS-PARSER - ANFANG
$inhaltsparser = config_read("inhaltsparser",$pfad."_config");  //KONFIGURATION FR INHALTSPARSER HOLEN
$inlineparser = config_read("inlineparser",$pfad."_config");  //KONFIGURATION FR INHALTSPARSER HOLEN

//WENN INHALTSPARSER AUF on
if(chop($inhaltsparser) == "on")  //IF INHALTSPARSER on/off
{
	//INLINEPARSEN EINSCHALTEN
	if(chop($inlineparser) == "on")
	{
		$inline = 1;  
	}
	
  //INHALTS-PARSER - ANFANG
  if(is_array($contentdaten))
  {
	  foreach($contentdaten as $v)	//EINGELESENE DATEI DURCHLAUFEN
	  {
	    // *******************************<geaendert kay Dittmann>**********************************************
      // Tags ersetzen
      //
      $v = ChangeTags($v, $tags);
      //
      // ******************************</geaendert Kay Dittmann>*********************************************
	    //-----------------------------------------------------------------------------------------------------------------------------------
	    //UMLAUTE UND SONDERZEICHEN ERSETZEN
	    $v = str_replace("","&Auml;",$v);
	    $v = str_replace("","&auml;",$v);
	    $v = str_replace("","&Ouml;",$v);
	    $v = str_replace("","&ouml;",$v);
	    $v = str_replace("","&Uuml;",$v);
	    $v = str_replace("","&uuml;",$v);
	    $v = str_replace("","&szlig;",$v);
	    //-----------------------------------------------------------------------------------------------------------------------------------
	    //PARSEN - ANFANG
	    //GEPARST WIRD NUR DAS ERSTE ZEICHEN JEDER EINGELESENEN ZEILE
	 	  switch(substr($v,0,1))  //ERSTES ZEICHEN PARSEN
	 	  {
	 	    case "/": switch(substr($v,0,2)) //TEXTFORMATIRUNGEN - ERSTEN BEIDEN ZEICHEN PARSEN
	 	              {
	 	                 case "/": if($inline == 1) { echo $nbsp."<i><b>".parsen_inline(substr($v,2),"","")."</b></i>".$br; break; } //KURSIV UND FETT
																						else { echo $nbsp."<i><b>".substr($v,2)."</b></i>".$br; break; } //KURSIV UND FETT
	 	                 default: if($inline == 1) { echo $nbsp."<i>".parsen_inline(substr($v,1),"","")."</i>".$br; break; }//KURSIV
																					else { echo $nbsp."<i>".substr($v,1)."</i><br>"; break; }//KURSIV
	 	              }
	 	              break;
			  case "": switch(substr($v,0,2)) //TEXTFORMATIERUNGEN - ERSTEN BEIDEN ZEICHEN PARSEN
	 	              {
	 	                 //********************************* <geaendert Kay Dittmann> *********************
	 	              	 case "": if($inline == 1) { echo parsen_inline(substr($v,2),"",""); break; }
	 	              	 //******************************** </geandert Kay Dittmann>***********************
	 	                 case "/": if($inline == 1) { echo $nbsp."<i><b>".parsen_inline(substr($v,2),"","")."</b></i>".$br; break; } //FETT UND KURSIV
																						else { echo $nbsp."<i><b>".substr($v,2)."</b></i><br>"; break; } //FETT UND KURSIV
	 	                 default: if($inline == 1) { echo $nbsp."<b>".parsen_inline(substr($v,1),"","")."</b>".$br; break; }
																					else { echo $nbsp."<b>".substr($v,1)."</b>".$br; break; } //FETT	 							
	 	              }
	 	              break;
        case "_": switch(substr($v,0,2)) //TEXTFORMATIERUNGEN - ERSTEN BEIDEN ZEICHEN PARSEN
	 	              {
	 	                 case "_": if($inline == 1) { echo $nbsp."<u><b>".parsen_inline(substr($v,2),"","")."</b></u>".$br; break; } //UNDERLINE UND FETT
																						else { echo $nbsp."<u><b>".substr($v,2)."</b></u>".$br; break; }//UNDERLINE UND FETT
	 	                 case "_/": if($inline == 1) { echo $nbsp."<u><i>".parsen_inline(substr($v,2),"","")."</i></u>".$br; break; }//UNDERLINE UND KURSIV
																						else { echo $nbsp."<u><i>".substr($v,2)."</i></u>".$br; break; }//UNDERLINE UND KURSIV
	 	                 case "__": if($inline == 1) { echo $nbsp."<u><b><i>".parsen_inline(substr($v,2),"","")."</b></i></u>".$br; break; }//UNDERLINE, FETT UND KURSIV
																						else { echo $nbsp."<u><b><i>".substr($v,2)."</b></i></u>".$br; break; }//UNDERLINE, FETT UND KURSIV
	 	                 default: if($inline == 1) { echo $nbsp."<u>".parsen_inline(substr($v,1),"","")."</u>".$br; break; }//UNDERLINE	
																					else { echo $nbsp."<u>".substr($v,1)."</u><".$br; break; }//UNDERLINE	 							
	 	              }
	 	              break;
        case "[": switch(substr($v,0,2)) //LISTTEN MIT BULLET - ERSTEN BEIDEN ZEICHEN PARSEN - LISTEN MIT PUNKT
	 	              {
	 	                 case "[{": switch(substr($v,0,3)) //ERSTEN BEIDEN ZEICHEN PARSEN
																{
																	case "[{1": echo "<ul type=\"circle\">\n"; break; //LISTE MIT RUNDEM LEEREM BULLET FFNEN
																	case "[{2": echo "<ul type=\"square\">\n"; break; //LISTE MIT GEFLLTEM VIERECK BULLET FFNEN 
																	default: echo "<ul type=\"disc\">\n"; break; //NORMALE LISTE MIT RUNDEM GEFLLTEM BULLET FFNEN
																}
																break;
	 	                 case "[}": echo "</ul>\n"; break; //NORMALE LISTE SCHLIESSEN
	 	                 default: if($inline == 1) { echo "<li>".parsen_inline(substr($v,1),"","")."</li>\n"; break; }
																					else { echo "<li>".substr($v,1)."</li>\n"; break; }//UNDERLINE	 							
	 	              }
	 	              break;
				case "]": switch(substr($v,0,2)) //LISTEN MIT NUMMERIERUNG - ERSTEN BEIDEN ZEICHEN PARSEN - LISTEN MIT ZAHLEN UND BUCHSTABEN
	 	              {
	 	                 case "]{": switch(substr($v,0,3)) //ERSTEN BEIDEN ZEICHEN PARSEN
																{
																	case "]{1": echo "<ol type=\"a\">\n"; break; //LISTE KLEINBUCHSTABENNUMMERIERUNG FFNEN
																	case "]{2": echo "<ol type=\"A\">\n"; break; //LISTE GROBUCHSTABENNUMMERIERUNG FFNEN
                                  case "]{3": echo "<ol type=\"i\">\n"; break; //LISTE MIT KLEINER RMISCHER NUMMERIERUNG FFNEN
																	case "]{4": echo "<ol type=\"I\">\n"; break; //LISTE MIT GROER RMISCHER NUMMERIERUNG FFNEN
																	default: echo "<ol type=\"1\">\n"; break; //NORMALE LISTE MIT ZAHLENNUMMERIERUNG FFNEN
																}
																break;
	 	                 case "]}": echo "</ol>\n"; break; //NORMALE LISTE SCHLIESSEN
	 	                 default: if($inline == 1) { echo "<li>".parsen_inline(substr($v,1),"","")."</li>\n"; break; }
																					else { echo "<li>".substr($v,1)."</li>\n"; break; }//UNDERLINE	 							
	 	              }
	 	              break;
        case "&": switch(substr($v,0,2)) //FARBIGER TEXT - ERSTEN BEIDEN ZEICHEN PARSEN
	 	              {
	 	                 case "&0": if($inline == 1) { echo $nbsp."<font color=\"#000000\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE black
																						else { echo $nbsp."<font color=\"#000000\">".substr($v,2)."</font><".$br; break; }//FARBE black
	 	                 case "&1": if($inline == 1) { echo $nbsp."<font color=\"#FFFFFF\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE white
																						else { echo $nbsp."<font color=\"#FFFFFF\">".substr($v,2)."</font>".$br; break; }//FARBE white
	 	                 case "&2": if($inline == 1) { echo $nbsp."<font color=\"#FFFF00\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE yellow
																						else { echo $nbsp."<font color=\"#FFFF00\">".substr($v,2)."</font>".$br; break; }//FARBE yellow
										 case "&3": if($inline == 1) { echo $nbsp."<font color=\"#FF0000\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; } //FARBE red
																						else { echo $nbsp."<font color=\"#FF0000\">".substr($v,2)."</font>".$br; break; } //FARBE red
	 	                 case "&4": if($inline == 1) { echo $nbsp."<font color=\"#0000FF\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE blue
																						else { echo $nbsp."<font color=\"#0000FF\">".substr($v,2)."</font>".$br; break; }//FARBE blue
	 	                 case "&5": if($inline == 1) { echo $nbsp."<font color=\"#000080\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE navy
																						else { echo $nbsp."<font color=\"#000080\">".substr($v,2)."</font>".$br; break; }//FARBE navy
	 	                 case "&6": if($inline == 1) { echo $nbsp."<font color=\"#008000\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE green
																						else { echo $nbsp."<font color=\"#008000\">".substr($v,2)."</font>".$br; break; }//FARBE green
	 	                 case "&7": if($inline == 1) { echo $nbsp."<font color=\"#00FFFF\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE aqua
																						else { echo $nbsp."<font color=\"#00FFFF\">".substr($v,2)."</font>".$br; break; }//FARBE aqua
	 	                 case "&8": if($inline == 1) { echo $nbsp."<font color=\"#00FF00\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE lime
																						else { echo $nbsp."<font color=\"#00FF00\">".substr($v,2)."</font>".$br; break; }//FARBE lime
	 	                 case "&9": if($inline == 1) { echo $nbsp."<font color=\"#C0C0C0\">".parsen_inline(substr($v,2),"","")."</font>".$br; break; }//FARBE silver
																						else { echo $nbsp."<font color=\"#C0C0C0\">".substr($v,2)."</font>".$br; break; }//FARBE silver
	 	                 //UMLAUTE EBENFALLS SCHREIBEN, WENN DIESE AN ERSTER STELLE STEHEN, SONST ERFOLGT KEINE AUSGABE
 		                 case "&A": if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$br; break; }
																						else { echo $nbsp.$v.$br; break; }
	 	                 case "&a": if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$br; break; }
																						else { echo $nbsp.$v.$br; break; }
	 	                 case "&O": if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$br; break; }
																						else { echo $nbsp.$v.$br; break; }
	 	                 case "&o": if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$br; break; }
																            else { echo $nbsp.$v.$br; break; }
	 	                 case "&U": if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$br; break; }
																						else { echo $nbsp.$v.$br; break; }
	 	                 case "&u": if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$br; break; }
																						else { echo $nbsp.$v.$br; break; }
	 	                 case "&s": if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$br; break; }
																						else { echo $nbsp.$v.$br; break; }
	 	                 default: if($inline == 1) { echo $nbsp.substr($v,1).$br; break; }//STANDARDFARBE, DIE IN DER verzeichnis.index.css EINGESTELLT IST	
																					else { echo $nbsp.substr($v,1).$br; break; }//STANDARDFARBE, DIE IN DER verzeichnis.index.css EINGESTELLT IST	 							
	 	              }
	 	              break;
				case ";":	switch(substr($v,0,3)) //FARBIGER HINTERGRUND - ERSTEN BEIDEN ZEICHEN PARSEN
									{	//div MIT ENTSPRECHENDER HINTERGRUNDFARBE FFNEN
										case ";{0":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#000000\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE black
																						else { echo $nbsp."<div style=\"background-color:#000000\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE black	
										case ";{1":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#FFFFFF\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE white
																						else { echo $nbsp."<div style=\"background-color:#FFFFFF\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE white	
										case ";{2":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#FFFF00\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE yellow
																						else { echo $nbsp."<div style=\"background-color:#FFFF00\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE yellow	
										case ";{3":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#FF0000\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE red
																						else { echo $nbsp."<div style=\"background-color:#FF0000\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE red	
										case ";{4":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#0000FF\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE blue
																						else { echo $nbsp."<div style=\"background-color:#0000FF\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE blue		
										case ";{5":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#000080\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE navy
																						else { echo $nbsp."<div style=\"background-color:#000080\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE navy	
										case ";{6":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#008000\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE green
																						else { echo $nbsp."<div style=\"background-color:#008000\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE green	
										case ";{7":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#00FFFF\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE aqua
																						else { echo $nbsp."<div style=\"background-color:#00FFFF\">".substr($v,3); "</div>".$br; break; }//HINTERGRUNDFARBE aqua	
										case ";{8":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#00FF00\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE lime
																						else { echo $nbsp."<div style=\"background-color:#00FF00\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE lime	
										case ";{9":	if($inline == 1) { echo $nbsp."<div style=\"background-color:#C0C0C0\">".parsen_inline(substr($v,3),"","")."</div>".$br; break; }//HINTERGRUNDFARBE silver
																						else { echo $nbsp."<div style=\"background-color:#C0C0C0\">".substr($v,3)."</div>".$br; break; }//HINTERGRUNDFARBE silver	
										default:	switch(substr($v,0,2)) //ERSTEN BEIDEN ZEICHEN PARSEN
															{
																case ";}": echo "</div>";  //div WIEDER SCHLIEEN - VERMEIDET SO ABSTZE ZWISCHEN DEN EINZELNEN div-TAGS
																					 break;
																default: if($inline == 1) { echo $nbsp.substr($v,1).$br; break; }//STANDARDFARBE, DIE IN DER verzeichnis.index.css EINGESTELLT IST	
																										else { echo $nbsp.substr($v,1).$br; break; }//STANDARDFARBE, DIE IN DER verzeichnis.index.css EINGESTELLT IST
															}
															break;
									}
									break;
	 		  case "%": switch(substr($v,0,2)) //BERSCHRIFTEN UND TABELLEN - ERSTEN BEIDEN ZEICHEN PARSEN
	 		            {
	 		              case "%%": if($inline == 1) { echo "<h3>".parsen_inline(substr($v,2),"","")."</h3>"; break; } //GROE BERSCHRIFT MIT NACHFOLGENDEM ABSATZ
																					 else { echo "<h3>".substr($v,2)."</h3>"; break; }//GROE BERSCHRIFT MIT NACHFOLGENDEM ABSATZ	 		
                    case "%": if($inline == 1) { echo "<h5>".parsen_inline(substr($v,2),"","")."</h5>"; break; }//KLEINE BERSCHRIFT MIT NACHFOLGENDEM ABSATZ  
																					 else { echo "<h5>".substr($v,2)."</h5>"; break; }//KLEINE BERSCHRIFT MIT NACHFOLGENDEM ABSATZ   
                    case "%{": switch(substr($v,0,3)) //TABELLEN - ERSTEN DREI ZEICHEN PARSEN
															 {
																 case "%{1": echo "<table width=\"100%\" border=\"1\" cellspacing=\"0\" cellpadding=\"2\">\n"; //TABELLE FFNEN - MIT 3D-RAND
                                             if(substr($v,3,7) == "nowidth") { $nowidth = TRUE; } //WENN nowidth DANN KEINE GLEICHEN SPALTENBREITEN
                                             break;
																 case "%{2": echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">\n"; //TABELLE FFNEN - MIT 2D-RAND -> FARBE DER TABELLE IN DER CSS IST DIE RANDFARBE
                                             if(substr($v,3,7) == "nowidth") { $nowidth = TRUE; } //WENN nowidth DANN KEINE GLEICHEN SPALTENBREITEN
                                             break;
																 default: echo "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\">\n"; //TABELLE FFNEN - OHNE RAND
                                          if(substr($v,2,7) == "nowidth") { $nowidth = TRUE; } //WENN nowidth DANN KEINE GLEICHEN SPALTENBREITEN
                                          break;
															 }
															 break;
                    case "%}": echo "</table>"; break; //TABELLE SACHLIESSEN
                    case "%<": echo "<tr>"; break; //TABELLENZEILE FFNEN
                    case "%>": echo "</tr>"; break; //TABELLENZEILE SCHLIESSEN
                    case "%[": echo "<td align=\"justify\" valign=\"top\">"; break; //TABELLENZELLE FFNEN
                    case "%]": echo "</td>"; break; //TABELLENZELLE SCHLIESSEN
                    case "%$": if($inline == 1) { echo parsen_inline(substr($v,2),"",""); break; }//INHALT IN DER TABELLENZELLE OHNE
																					 else { echo substr($v,2); break; }                     //ZEILENUMBRUCH FR BLOCKSATZ-SCHRIFTBILD
                    case "%~": if($inline == 1) { echo "<th>".parsen_inline(substr($v,2),"","")."</th>\n"; break; }//TABELLENKOPF
																					 else { echo "<th>".substr($v,2)."</th>\n"; break; }//TABELLENKOPF
                    case "%*": if($inline == 1) { echo "<td align=\"justify\" valign=\"top\">".parsen_inline(substr($v,2),"","")."</td>\n"; break; }//TEXT IN TABELLENSPALTE
																					 else { echo "<td align=\"justify\" valign=\"top\">".substr($v,2)."</td>\n"; break; }//TEXT IN TABELLENSPALTE
										//ALTERNATIVE TABELLENZEILEN
                    case "%|": switch(substr($v,0,3)) //ERSTEN DREI ZEICHEN PARSEN
                               { //TABELLENKOPF SCHREIBEN
																 case "%||": $row_array = explode("||",$v); //TABELLE IN ARRAY AUFTRENNEN
																						 $row_array = array_slice($row_array,1,count($row_array)-2); //ERSTES UND LETZTE ELEMENT ENTFERNEN, WEIL SIE LEER SIND
																						 if(is_array($row_array)) 											//WENN ARRAY
																						 {
																						   if($nowidth)                                 //WENN KEINE BREITENBERECHNUNG
																						   {
																						     $col_width = 0;                            //BREITE EBEN 0
																						   }
																						   else                                         //SONST
																						   {
																							   $col_width = 100 / count($row_array); 			//JEWEILIGE BREITE AUSRECHNEN
																							 }
																							 echo "<tr>"; 																//ZEILE FFNEN	
																							 foreach($row_array as $row_val)							//ARRAY DURCHLAUFEN
																							 {
																								 if($inline == 1) { echo "<th width=\"$col_width%\" valign=\"top\">".parsen_inline($row_val,"","")."</th>\n"; } 	//KOPF SCHREIBEN
																														 else { echo "<th width=\"$col_width%\" valign=\"top\">".$row_val."</th>\n"; } 	//KOPF SCHREIBEN
																							 }
																							echo "</tr>";																	//ZEILE SCHLIEEN
																						}
																						break;
																 //STANDARDMIG NORMALE SPALTEN SCHREIBEN	
																 default:	$row_array = explode("|",$v); 	//TABELLE IN ARRAY AUFTRENNEN
																					$row_array = array_slice($row_array,1,count($row_array)-2);	//ERSTES UND LETZTE ELEMENT ENTFERNEN, WEIL SIE LEER SIND
																					if(is_array($row_array))													//WENN ARRAY
																					{
																					  if($nowidth)                                 //WENN KEINE BREITENBERECHNUNG
																						{
																						  $col_width = 0;                            //BREITE EBEN 0
																						}
																						else                                         //SONST
																						{
																						  $col_width = 100 / count($row_array);		//JEWEILIGE BREITE AUSRECHNEN
																						}
																						echo "<tr>"; 														//ZEILE FFNEN	
																						foreach($row_array as $row_val)					//ARRAY DURCHLAUFEN
																						{
																							switch(substr($row_val,0,1))
																							{
																								case "[": $align = "left"; $row_val = substr($row_val,1); break; 		//AUSRICHTUNG DER ZELLE NACH LINKS
																								case ";": $align = "center"; $row_val = substr($row_val,1); break;	//AUSRICHTUNG DER ZELLE MITTIG
																								case "]": $align = "right"; $row_val = substr($row_val,1); break;		//AUSRICHTUNG DER ZELLE NACH RECHTS
																								default: $align = "justify"; break;																	//AUSRICHTUNG DER ZELLE JYSTIFY - BLOCKSATZ
																							}
																							if($inline == 1) { echo "<td width=\"$col_width%\" align=\"$align\" valign=\"top\">".parsen_inline($row_val,"","")."</td>"; } //ZEILE SCHREIBEN
																													else { echo "<td width=\"$col_width%\" align=\"$align\" valign=\"top\">".$row_val."</td>"; }
																						}
																						echo "</tr>";														//ZEILE SCHLIEEN
																					}
																					break;
															 }
															 break;
                    case "%@": $tablink = explode("@",substr($v,2)); //SEITENLINK IN TABELLENSPALTE 
                               echo "<td align=\"justify\" valign=\"top\"><a href=\"".$tablink[0]."\" target=\"_blank\">&nbsp;".chop($tablink[1])."&nbsp;</a></td>";
                    					 break; 
                    case "%&": switch(substr($v,0,3)) //UMLAUTE - ERSTEN DREI ZEICHEN PARSEN
                               {
                                 //UMLAUTE EBENFALLS SCHREIBEN
                                 case "%&A": if($inline == 1) { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$br; break; }
																												 else { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$br; break; }
	 	                             case "%&a": if($inline == 1) { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$br; break; }
																												 else { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$br; break; }
	 	                             case "%&O": if($inline == 1) { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$br; break; }
																												 else { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$br; break; }
	 	                             case "%&o": if($inline == 1) { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$br; break; }
																												 else { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$br; break; }
	 	                             case "%&U": if($inline == 1) { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$br; break; }
																												 else { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$br; break; }
	 	                             case "%&u": if($inline == 1) { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$br; break; }
																												 else { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$br; break; }
	 	                             case "%&s": if($inline == 1) { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$br; break; }
																												 else { echo "<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$br; break; }
                                 default: $tablink = explode("@",substr($v,2));   //BILDLINK IN TABELLENSPALTE	
                    					            echo "<td align=\"center\" valign=\"middle\"><a href=\"".$tablink[0]."\" target=\"_blank\"><img src=\"".$tablink[1]."\" border=\"0\" alt=\"".$tablink[2]."\"></a></td>";
                    					            break;
                    					 }
                    					 break;
                    case "%_": if($inline == 1) { echo $prep."<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><u><b>".parsen_inline(substr($v,2),"","")."</b></u></font>".$postp; break; }//KLEINE UNTERSTRICHENE BERSCHRIFT
																					 else { echo $prep."<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><u><b>".substr($v,2)."</b></u></font>".$postp; break; }//KLEINE UNTERSTRICHENE BERSCHRIFT
	 		              default: if($inline == 1) { echo $prep."<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".parsen_inline(substr($v,1),"","")."</b></font>".$ubr; break; }//KLEINE BERSCHRIFT OHNE ABSATZ	 							
																				 else { echo $prep."<font size=\"2\" face=\"Tahoma,Arial,Helvetica\"><b>".substr($v,1)."</b></font>".$ubr; break; }//KLEINE BERSCHRIFT OHNE ABSATZ	 							
					          //default GIBT IMMER NUR AB DEM ERSTEM ZEICHEN AUS
	 		            }
	 		            break;
	 		  case "*": switch(substr($v,0,2)) //ERSTEN BEIDEN ZEICHEN PARSEN
	 	              { //BEI HTML-DATEIEN HAT BEIDES DIE GLEICHE WIRKUNG - BEI PHP-DATEIN NICHT
	 	               	case "**": readfile(chop(substr($v,2))); break; //ANGEGEBENE DATEI INCLUDEN - INHALT WIRD AUF BILDSCHIRM AUSGEGEBEN (BEI PHP-CODE)
	 	               	case "*~": show_source(chop(substr($v,2))); //QUELLTEXT EINER PHP-DATEI MIT SYNTAXHIGHLIGHTING ANZEIGEN - BEI HTML-DATEI WIRD CODE UND TEXT MIT EINRCKUNGEN AUSGEGEBEN
	 	               	default: @include(chop(substr($v,1))); //ANGEGEBENE DATEI AUSGEBEN - Z.B. FR ZUSTZLICHE FUNKTIONEN
	 	              }
	 							  break;
	      case " ": if($inline == 1) { echo $nbsp.$nbsp.parsen_inline(substr($v,1),"","").$br; break; } //ZEILE EINRCKEN
															else { echo $nbsp.$nbsp.substr($v,1).$br; break; }  //ZEILE EINRCKEN
				case "@": switch(substr($v,0,2)) //ERSTEN BEIDEN ZEICHEN PARSEN
	 	              {	
	 	                 case "@@": $link = explode("@",substr($v,2)); 
										 						echo $nbsp."<a href=\"".$link[0]."\" target=\"_blank\">&nbsp;".$link[1]."&nbsp;</a>".$br; break; //LINK SETZEN
										 case "@&": $link = explode("@",substr($v,2)); 
										 						echo "<img src=\"".$link[0]."\" border=\"0\" alt=\"".$link[1]."\">"; break; //BILD - HIER SCREENSHOT
	 	                 default: $link = explode("@@",substr($v,1));
										  			  echo $nbsp."E-Mail:&nbsp;<a href=\"mailto:".$link[0]."\">&nbsp;".$link[1]."&nbsp;</a>".$br; break; //E-MAIL-ADRESSE SETZEN	 							
	 	              }
									break;					
	 		  case "=": switch(substr($v,0,2)) //ERSTEN BEIDEN ZEICHEN PARSEN
									{
										case "==": echo "<hr width=\"100%\" size=\"2\" noshade>"; break;  //DICKE TRENNLINIE
										case "={": echo "<fieldset>"; break; //FIELDSET FFNEN
										case "=}": echo "</fieldset>"; break; //FIELDSET SCHLIEEN
										default: echo "<hr width=\"100%\" size=\"1\" noshade>";  //DNNE TRENNLINIE
														 break;
									}
									break;
				case "\\": echo $nbsp. substr($v,1) . "<br>"; //ESCAPEN - Z.B. FR UNFORMATIERTE AUSGABEN ZUR DARTSELLUNG VON STEUERZEICHEN
								  break;
				case "#": break; //KOMMENTAR
	 		  //WENN KEINES DER ZEICHEN ZUTRIFFT
	 		  default: if(substr($v,0,1) != "#"
                 && substr($v,0,1) != "~"
                 && substr($v,0,1) != "*"
                 && substr($v,0,1) != " "
	 		           && substr($v,0,2) != "~~"
                 && substr($v,0,2) != "~"
                 && substr($v,0,2) != "~?"
                 && substr($v,0,2) != "~!"
	               && substr($v,0,2) != "**"
                 && substr($v,0,2) != "*~"
                 && substr($v,0,1) != "&"
                 && substr($v,0,1) != "@"
                 && substr($v,0,1) != "["
                 && substr($v,0,1) != "_")
	 					  	 {
										//STANDARDAUSGABE
										if($inline == 1) { echo $nbsp.parsen_inline($v,"","").$tinybr; }
																else { echo $nbsp.$v.$tinybr; }
	 						    }  
	 						   //VARIABLEN ZERSTREN  
	 						   unset($suchstring);
	 						   unset($linkswitch);
	 						   unset($linkarray);
								 unset($bildarray);
								 unset($nowidth);
	 						   break;
	   	}
	 	  //PARSEN - ENDE
	    //-----------------------------------------------------------------------------------------------------------------------------------
	 	
	  } //FOREACH
  }//IF
} //IF INHALSTPARSER on/off
//INHALTS-PARSER - ENDE
//########################################################################################################################################
//PARSER-MODULE - ANFANG
$parsermodul = config_read("parsermodule",$pfad."_config");  //KONFIGURATION FR LINKINDEX HOLEN

//WENN PARSERMODULE AUF on - AUSGABE
if(chop($parsermodul) == "on")  //IF LINKINDEX on/off
{
  $verz=@opendir ($pfad);											//RELATIVES VERZEICHNIS IN $pfad FFNEN

  while ($file = @readdir ($verz)) 						//JEDEN EINTRAG LESEN
  {
		if(is_file($pfad.$file) && preg_match("/modul/",$pfad.$file)) //NUR WENN $file EINE DATEI IST UND "matcht" IST
		{
			$parsermodul = explode(".",$file);  //DATEI AUFSPALTEN
			if($parsermodul[1] == "parser")     //WENN AN ZWEITER STELLE parser STEHT
			{
			  include_once($pfad.$file);        //DANN DATEI INCLUDEN
			}	
		}
  }

  @closedir($verz);                        //VERZEICHNIS SCHLIEEN
} //IF PARSERMODUL on
//PARSER-MODULE - ENDE
//########################################################################################################################################
if(!isset($content_other_file))  //NICHT BEI DATEIEN IM ERWEITERTEM FRAMESET
{
  //LINKINDEX SORTIERT SCHREIBEN
  $linkindex = config_read("linkindex",$pfad."_config");  //KONFIGURATION FR LINKINDEX HOLEN

  //WENN LINKINDEX AUF on - AUSGABE
  if(chop($linkindex) == "on")  //IF LINKINDEX on/off
  {
    //	DATEIEN SCHREIBEN
    if(is_array($pufferfile))											//WENN WERTE IN ARRAY
    {
	    echo "<br><font size=1><b>Downloads</b></font><br>";  //BERSCHRIFT FR AUSGEBEN
	    sort($pufferfile);													//AUFSTEIGEND SORTIEREN

	    foreach($pufferfile as $k => $v)						//JEDES ARRAYELEMENT DURCHLAUFEN
	    {
		    echo $nbsp.$v;																	//VALUE AUSGEBEN
	    }
    }
    else
    {
      //KANN BEI BEDARF AKTIVIERT WERDEN
	    //echo "<br><font size=1><b>Keine Dateien enthalten !</b></font><br>";  //HINWEIS AUF NICHT VORHANDENE DATEIEN AUSGEBEN
    }
  } //IF LINKINDEX on/off - AUSGABE
  //########################################################################################################################################
  //TRENNLINIE MIT FUSSZEILE
  echo "<hr width=\"100%\" size=\"1\" noshade>";
  echo "<center><font size=\"1\">$copyright&nbsp;&nbsp;&nbsp;&nbsp;$letzte_bearbeitung&nbsp;&nbsp;&nbsp;&nbsp;$statistik</font></center>";
} //$content_other_file

//FU HTML-SCHREIBEN  
echo <<<FUSS
		</font>
	</body>
	</html>
FUSS;

//TEST - $pfad AUS DER JEWEILIGEN index.php IN DEN VERZEICHNISSEN
//include($pfad."at.txt");
?>
