<?php
/************************************************************
~ GRUNDIDEE: Christian Schlichting  2002
~ BEARBEITUNG UND WEITERENTWICKLUNG: Andreas Theusner  2003-2011
~  - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator
~ DATEI: core.menu.php
~ ZWECK: Linkgenerator fr ausklappbare Mens
~************************************************************

~************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
~************************************************************
~ FUNKTIONSWEISE 
~	--------------
~	Es werden Verzeichnisse als Links generiert und in einem
~	Men angeordnet. Enthlt ein Link ein Untermen (sprich
~	Unterverzeichnis), klappt der Link mit einem Untermen
~ im Explorerstil nach unten und eingerckt aus.
~
~ VORAUSSETZUNGEN FR Die FUNKTIONALITT DES LINKGENERATORS
~	---------------------------------------------------------
~	- ein einstelliger numerischer Wert vor dem Verzeichnisname
~		in folgendem Format: 1_Verzeichnisname (Unterstrich ist
~		notwendig); hier kann der erste Buchstabe gro oder klein
~		geschrieben werden; der numerische Wert dient als
~		Sortierungskriterium fr das Verzeichnis          
~
~	- ist kein numerischer Wert vorhanden, dann wird das 
~		Verzeichnis nur angezeigt, wenn der erste Buchstabe
~		gro geschrieben ist; ist er klein geschrieben, wird
~		das Verzeichnis nicht als Link im Men angezeigt;
~   hier dient der Anfangsbuchstabe als Sortierkriterium
~
~	- damit ein Verzeichnis als Link generiert werden kann,
~		mu sich in diesem mindestens eine Datei mit folgendem
~		Namen befinden: index.php
~
~ - HINWEIS:
~   Die index.php fr den Verzeichniszugriff ist nicht identisch
~   mit der index.php im Root (Verzeichniswurzel) der Website!
~   Diese index.php enthlt den Parser fr content.txt.
~
~	- damit ein Men auch dann automatisch zuklappt, wenn 
~		ein anderer Menpunkt kein Untermen hat, sollte
~		unter diesen Menpunkt ein Dummy-Verzeichnis als Zahl
~		(z.B. 1 oder 1_) angelegt und dort eine index.php
~		hineinkopiert werden 
~
~ - Verzeichnisnamen, Die als Men generiert werden sollen,
~   drfen keine Sonderzeichen und Umlaute wie , , , 
~   enthalten
~
~ SYSTEME
~ -------
~ Die Lauffhigkeit wurde erfolgreich unter Linux und Windows
~ jeweils mit verschiedenen Apache- und php-Versionen
~ erfolgreich getestet.
~
~ BROWSER
~ -------
~ Erfolgreich getestet im Internet Explorer ab Version 4,
~ Netscape ab Version 4.7x und Opera ab Version 6.xx
~
~ HINWEISE
~ --------
~ detailliertere Kommentare sind im Quelltext zu finden
************************************************************/

/************************************************************
* Funktionen
************************************************************/ 
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

//INCLUDES
include_once("core.config.php");

//CONFIGURATION UND INIT
//KONFIGURATION FR STYLE HOLEN - PFAD ZUM STYLE
$stylepfad = config_read("stylepfad",$pfad."_config");
$stylepfad = chop($stylepfad);

//FRAMESETART HOLEN
$frames = config_read("frameset",$pfad."_config");

//MENBUTTONS HOLEN
$menubuttons = config_read("menubuttons","_config");  //KONFIGURATION FR HAUPTMENBUTTONS HOLEN
$menusubbuttons = config_read("menusubbuttons","_config");  //KONFIGURATION UNTERMENBUTTONS HOLEN
//-------------------------------------------------------------------------------
//HAUPTMEN - ABSTNDE FR MEN IM BUTTONMODUS HOLEN
$distance = config_read("menurand",$pfad."_config");  //DICKE DES MENRANDES
if(chop($distance) > "") { $menurand = chop($distance); } else { $menurand = 0; }

$distance = config_read("menu2rand",$pfad."_config"); //ABSTAND MENTEXT ZUM MENRAND
if(chop($distance) > "") { $menu2rand = chop($distance); } else { $menu2rand = 0; }

$distance = config_read("menu2menu",$pfad."_config"); //ABSTNDE ZWISCHEN DEN MENPUNKTEN
if(chop($distance) > "") { $menu2menu = chop($distance); } else { $menu2menu = 0; }

//MENBREITE FR SEITEN-HAUPTMENS
$width = config_read("menuwidth",$pfad."_config");
if(chop($width) > "") { $menuwidth = chop($width); } else { $menuwidth = "100%"; }
//-----------------------
//UNTERMENS - ABSTNDE FR MEN IM BUTTONMODUS HOLEN
$subdistance = config_read("submenurand",$pfad."_config");  //DICKE DES MENRANDES
if(chop($subdistance) > "") { $submenurand = chop($subdistance); } else { $submenurand = 0; }

$subdistance = config_read("submenu2rand",$pfad."_config"); //ABSTAND MENTEXT ZUM MENRAND
if(chop($subdistance) > "") { $submenu2rand = chop($subdistance); } else { $submenu2rand = 0; }

$subdistance = config_read("submenu2menu",$pfad."_config"); //ABSTNDE ZWISCHEN DEN MENPUNKTEN
if(chop($subdistance) > "") { $submenu2menu = chop($subdistance); } else { $submenu2menu = 0; }

//MENBREITE FR SEITEN-UNTERTMENS
$subwidth = config_read("submenuwidth",$pfad."_config");
if(chop($subwidth) > "") { $submenuwidth = chop($subwidth); } else { $submenuwidth = "100%"; }
//-------------------------------------------------------------------------------

//MENLINIEN
$menulines = config_read("menulines","_config");  //KONFIGURATION MENULINES HOLEN

if(chop($menulines) == "on")
{
  $mLines = "<tr><td><hr size=\"1\" noshade></td></tr>";
}


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
~ NAME: function is_big ($text) 
~ ART: php-Script
~ ZWECK: berprft, ob erstes Zeichen eine einstellige Zahl
~        oder ein Gro-/Kleinbuchstabe ist -> ASCII-Bereich 49 - 90 
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/ 
  function is_big ($text) 
  {
  	$return=false;
    if ((ord($text) > 48) && (ord($text)< 91)) 
    {
			$return=true;
    }
      
  	return $return;
  }
  
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
~ NAME: function no_index ($file)
~ ART: php-Script
~ ZWECK: berprft, ob Index-Dateien im Verzeichnis sind
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
  function no_index ($file) 
  {
  	if (($file != "index.php") && ($file != "index.html") && ($file != "index.htm")) 
  	{
			$return=true;
    } 
    else
    {
			$return=false;
    }
    
  	return $return;
  }                                                          
  
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~ NAME: function other_index ($dir) 
~ ART: php-Script
~ ZWECK: berprft, ob andere Verzeichnisse mit groem Anfangsbuchstaben
~        und ohne fhrender Zahl vorhanden sind
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/ 
  function other_index ($dir) 
  {
  	$return=false;
    $handle=opendir($dir);
    while (($file = readdir($handle))!==false) 
    {
			if (is_file("$dir/$file") && is_big($file)) 
			{
	  		$return=true;
	  		break;
			}
    }
    
    closedir($handle);
    return $return;
  }

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
~ NAME: function exist_sub ($dir)
~ ART: php-Script
~ ZWECK: berprft, ob ein Verzeichnis existiert
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
  function exist_sub ($dir) 
  {
  	$return=false;
    $handle=opendir($dir);

    while (($file = readdir($handle))!==false) 
    {
			if ((is_dir("$dir/$file") && ($file != ".") && ($file != "..") && is_big($file)) || (other_index($dir))) 
			{
	  		$return=true;break;
			}
    }
      
    closedir($handle);
    return $return;
  }

/************************************************************************************
~ NAME: function char_mapping ($chars)
~ ART: php-Script
~ ZWECK: ersetzt Zeichenfolgen durch Zeichen im Men, die nicht in Ordnerbezeichnungen
~        akzeptiert werden
~ BEMERKUNG:
~				SONDERZEICHEN: PARSEN UND EINFUEGEN 
~					-> 	BEISPIEL: DER VERZEICHNISNAME LAUTET 1_Software[SLASH]Office
~							DANN WIRD DER MENPUNKT SO GENERIERT: Softare/Office
~ HINWEIS: ...OP = ffnen des Tags
~					 ...CL = schlieen des Tags
*************************************************************************************/
	function char_mapping ($chars)
	{
		//UMLAUTE
		if(preg_match("/[Ae]/",$chars))						{ $chars = str_replace("[Ae]","&Auml;",$chars); }
		if(preg_match("/[ae]/",$chars))						{ $chars = str_replace("[ae]","&auml;",$chars); }
		if(preg_match("/[Oe]/",$chars))						{ $chars = str_replace("[Oe]","&Ouml;",$chars); }
		if(preg_match("/[oe]/",$chars))						{ $chars = str_replace("[oe]","&ouml;",$chars); }
		if(preg_match("/[Ue]/",$chars))						{ $chars = str_replace("[Ue]","&Uuml;",$chars); }
		if(preg_match("/[ue]/",$chars))						{ $chars = str_replace("[ue]","&uuml;",$chars); }
		if(preg_match("/[sz]/",$chars))						{ $chars = str_replace("[sz]","&szlig;",$chars); }
		
		//KLAMMERN
		if(preg_match("/[KL1OP]/",$chars))				{ $chars = str_replace("[KL1OP]","(",$chars); }
		if(preg_match("/[KL1CL]/",$chars))				{ $chars = str_replace("[KL1CL]",")",$chars); }
		if(preg_match("/[KL2OP]/",$chars))				{ $chars = str_replace("[KL2OP]","{",$chars); }
		if(preg_match("/[KL2CL]/",$chars))				{ $chars = str_replace("[KL2CL]","}",$chars); }
		if(preg_match("/[KL3OP]/",$chars))				{ $chars = str_replace("[KL3OP]","[",$chars); }
		if(preg_match("/[KL3CL]/",$chars))				{ $chars = str_replace("[KL3CL]","]",$chars); }
		if(preg_match("/[KL4OP]/",$chars))				{ $chars = str_replace("[KL4OP]","&lt;",$chars); }
		if(preg_match("/[KL4CL]/",$chars))				{ $chars = str_replace("[KL4CL]","&gt;",$chars); }
		if(preg_match("/[KL5OP]/",$chars))				{ $chars = str_replace("[KL5OP]","&laquo;",$chars); }
		if(preg_match("/[KL5CL]/",$chars))				{ $chars = str_replace("[KL5CL]","&raquo;",$chars); }
		
		//FARBEN
		if(preg_match("/[BLACKOP]/",$chars))			{ $chars = str_replace("[BLACKOP]","<font color=\"#000000\">",$chars); }		 	//schwarz
		if(preg_match("/[BLACKCL]/",$chars))			{ $chars = str_replace("[BLACKCL]","</font>",$chars); }
		if(preg_match("/[WHITEOP]/",$chars))			{ $chars = str_replace("[WHITEOP]","<font color=\"#FFFFFF\">",$chars); }		 	//wei
		if(preg_match("/[WHITECL]/",$chars))			{ $chars = str_replace("[WHITECL]","</font>",$chars); }
		if(preg_match("/[YELLOWOP]/",$chars))			{ $chars = str_replace("[YELLOWOP]","<font color=\"#FFFF00\">",$chars); } 		//gelb
		if(preg_match("/[YELLOWCL]/",$chars))			{ $chars = str_replace("[YELLOWCL]","</font>",$chars); }
		if(preg_match("/[REDOP]/",$chars))				{ $chars = str_replace("[REDOP]","<font color=\"#FF0000\">",$chars); }				//rot
		if(preg_match("/[REDCL]/",$chars))				{ $chars = str_replace("[REDCL]","</font>",$chars); }
		if(preg_match("/[BLUEOP]/",$chars))				{ $chars = str_replace("[BLUEOP]","<font color=\"#0000FF\">",$chars); }				//blau
		if(preg_match("/[BLUECL]/",$chars))				{ $chars = str_replace("[BLUECL]","</font>",$chars); }
		if(preg_match("/[NAVYOP]/",$chars))				{ $chars = str_replace("[NAVYOP]","<font color=\"#000080\">",$chars); }				//navy
		if(preg_match("/[NAVYCL]/",$chars))				{ $chars = str_replace("[NAVYCL]","</font>",$chars); }
		if(preg_match("/[GREENOP]/",$chars))			{ $chars = str_replace("[GREENOP]","<font color=\"#008000\">",$chars); }			//grn
		if(preg_match("/[GREENCL]/",$chars))			{ $chars = str_replace("[GREENCL]","</font>",$chars); }
		if(preg_match("/[AQUAOP]/",$chars))				{ $chars = str_replace("[AQUAOP]","<font color=\"#00FFFF\">",$chars); }				//auqa
		if(preg_match("/[AQUACL]/",$chars))				{ $chars = str_replace("[AQUACL]","</font>",$chars); }
		if(preg_match("/[LIMEOP]/",$chars))				{ $chars = str_replace("[LIMEOP]","<font color=\"#00FF00\">",$chars); }				//lime
		if(preg_match("/[LIMECL]/",$chars))				{ $chars = str_replace("[LIMECL]","</font>",$chars); }
		if(preg_match("/[SILVEROP]/",$chars))			{ $chars = str_replace("[SILVEROP]","<font color=\"#C0C0C0\">",$chars); }			//silver
		if(preg_match("/[SILVERCL]/",$chars))			{ $chars = str_replace("[SILVERCL]","</font>",$chars); }
		
		//FORMATIERUNG
		if(preg_match("/[BOP]/",$chars))					{ $chars = str_replace("[BOP]","<b>",$chars); }				//bold
		if(preg_match("/[BCL]/",$chars))					{ $chars = str_replace("[BCL]","</b>",$chars); }
		if(preg_match("/[IOP]/",$chars))					{ $chars = str_replace("[IOP]","<i>",$chars); }				//kursiv
		if(preg_match("/[ICL]/",$chars))					{ $chars = str_replace("[ICL]","</i>",$chars); }
		if(preg_match("/[BIOP]/",$chars))					{ $chars = str_replace("[BIOP]","<b><i>",$chars); }   //bold und kursiv
		if(preg_match("/[BICL]/",$chars))					{ $chars = str_replace("[BICL]","</b></i>",$chars); }
		if(preg_match("/[UOP]/",$chars))					{ $chars = str_replace("[UOP]","<u>",$chars); }				//underline
		if(preg_match("/[UCL]/",$chars))					{ $chars = str_replace("[UCL]","</u>",$chars); }
		if(preg_match("/[BR]/",$chars))						{ $chars = str_replace("[BR]","<br>",$chars); }    		//Zeilenumbruch
		if(preg_match("/[P]/",$chars))						{ $chars = str_replace("[P]","<p>",$chars); }      		//Absatz
		if(preg_match("/[SPACE]/",$chars))				{ $chars = str_replace("[SPACE]","&nbsp;",$chars); } 	//Leerzeichen
		
		//AUSRICHTUNG - FUNKTIONIERT DERZEIT NICHT KORREKT
		/*if(preg_match("/[CENTER]/",$chars))		//mittig		
		{ 
			$chars_buffer = str_replace("[CENTER]","",$chars);
			$chars = str_replace("[CENTER]","<center>$chars_buffer</center>",$chars); 
		}      		
		
		if(preg_match("/[LEFT]/",$chars))		//links			
		{ 
			$chars_buffer = str_replace("[LEFT]","",$chars);
			$chars = str_replace("[LEFT]","<p align=\"left\">$chars_buffer</p>",$chars); 
		}      	
		
		if(preg_match("/[RIGHT]/",$chars))	//rechts			
		{ 
			$chars_buffer = str_replace("[RIGHT]","",$chars);
			$chars = str_replace("[RIGHT]","<p align=\"right\">$chars_buffer</p>",$chars); 
		}     
		
		if(preg_match("/[JUSTIFY]/",$chars))	//Blocksatz		
		{ 
			$chars_buffer = str_replace("[JUSTIFY]","",$chars);
			$chars = str_replace("[JUSTIFY]","<p align=\"justify\">$chars_buffer</p>",$chars); 
		}	*/
		
		//DIVERSE SONDERZEICHEN
		if(preg_match("/[SLASH]/",$chars))				{ $chars = str_replace("[SLASH]","/",$chars); }
		if(preg_match("/[BACKSLASH]/",$chars))		{ $chars = str_replace("[BACKSLASH]","\\",$chars); }
		if(preg_match("/[PIPE]/",$chars))					{ $chars = str_replace("[PIPE]","|",$chars); }
		if(preg_match("/[KL6]/",$chars))					{ $chars = str_replace("[KL6]","^",$chars); }
		if(preg_match("/[LIST]/",$chars))					{ $chars = str_replace("[LIST]","",$chars); }
		if(preg_match("/[PLUS]/",$chars))					{ $chars = str_replace("[PLUS]","+",$chars); }
		if(preg_match("/[PLUSMINUS]/",$chars))		{ $chars = str_replace("[PLUSMINUS]","&plusmn;",$chars); }
		if(preg_match("/[AT]/",$chars))						{ $chars = str_replace("[AT]","@",$chars); }
		if(preg_match("/[EURO]/",$chars))					{ $chars = str_replace("[EURO]","",$chars); }
		if(preg_match("/[DOLLAR]/",$chars))				{ $chars = str_replace("[DOLLAR]","$",$chars); }
		if(preg_match("/[TILDE]/",$chars))				{ $chars = str_replace("[TILDE]","~",$chars); }
		if(preg_match("/[QUOTE]/",$chars))				{ $chars = str_replace("[QUOTE]","&quot;",$chars); }
		if(preg_match("/[AMP]/",$chars))					{ $chars = str_replace("[AMP]","&amp;",$chars); }
		if(preg_match("/[PROZENT]/",$chars))			{ $chars = str_replace("[PROZENT]","%",$chars); }
		if(preg_match("/[AUSRUF]/",$chars))				{ $chars = str_replace("[AUSRUF]","!",$chars); }
		if(preg_match("/[FRAGE]/",$chars))				{ $chars = str_replace("[FRAGE]","?",$chars); }
		if(preg_match("/[RAUTE]/",$chars))				{ $chars = str_replace("[RAUTE]","#",$chars); }
		if(preg_match("/[SEMIKOLON]/",$chars))		{ $chars = str_replace("[SEMIKOLON]",";",$chars); }
		if(preg_match("/[DOPPELPUNKT]/",$chars))	{ $chars = str_replace("[DOPPELPUNKT]",":",$chars); }
		if(preg_match("/[GLEICH]/",$chars))				{ $chars = str_replace("[GLEICH]","=",$chars); }
		if(preg_match("/[COPY]/",$chars))					{ $chars = str_replace("[COPY]","&copy;",$chars); }
		if(preg_match("/[REG]/",$chars))					{ $chars = str_replace("[REG]","&reg;",$chars); }
		if(preg_match("/[PARAG]/",$chars))				{ $chars = str_replace("[PARAG]","&sect;",$chars); }
		if(preg_match("/[VIERTEL]/",$chars))			{ $chars = str_replace("[VIERTEL]","&frac14;",$chars); }
		if(preg_match("/[HALB]/",$chars))					{ $chars = str_replace("[HALB]","&frac12;",$chars); }
		if(preg_match("/[DREIVIERTEL]/",$chars))	{ $chars = str_replace("[DREIVIERTEL]","&frac34;",$chars); }
		
		return $chars;
	}

/************************************************************************************
~ NAME: function print_link ($Link,$label,$LEVEL,$target="")
~ ART: php-Script
~ ZWECK: generiert Die Links als Navigation
~ -> ermglicht den Effekt des scheinbaren Auf- und Zuklappens des Mens
~ $Link = Linkadresse
~ $label = Linkbezeichnung
~ $LEVEL = Verzeichnistiefe
~ $root = Webserver-Rootverzeichnis (z.B. /usr/local/httpd/htdocs)
~         darf nicht im Aufruf der Funktion erscheinen, sondern mu hier
~         eingestellt werden
~         -> mu identisch sein mit Wert von $serverrot in der index.php fr
~            den Verzeichniszugriff, wenn diese in Unterverzeichnissen liegt
~            Einstellung in der core.parser.php, die von index.php included wird
~            Die als Men generiert werden sollen
~         -> bei Einrichtung auf einem Server mu der physikalische Pfad hier
~            eingetragen werden - ohne abschlieendem Slash (/)
~ $target = Zielfenster (z.B. Frame oder _blank) 
*************************************************************************************/
  //function print_link ($Link,$label,$level,$target="",$root="/usr/local/httpd/htdocs")
  function print_link ($link,$label,$level,$menu,$target="")
  {
		global $stylepfad;	//PFAD DES STYLES IMPORTIEREN
		global $edit;       //EDITIERVARIABLE - WIRD GLOBAL IN $GLOBALS VORGEHALTEN
		global $frames;     //FRAMESETART IMPORTIEREN
		global $menubuttons; //HAUPTMENBUTTONS
    global $menusubbuttons; //UNTERMENBUTTONS
		global $menurand;   //MENRAND
    global $menu2rand;  //ABSTAND MENTEXT ZUM RAND
    global $menu2menu;  //ABSTNDE ZWISCHEN MENPUNKTEN
    global $mLines;     //MENLINIEN
		
		
		
    if($edit == 1) { $edit = 1; } //WENN CONTENATOR IM EDITIERMODUS AUFGERUFEN WURDE, FR LINKVARIABLE
    
    $root = config_read("serverpfad","_config");  //KONFIGURATION FR SERVERPFAD HOLEN
    
    if ($level == 0)  //WENN EINTRAG FR HAUPTMEN
    {
			
			//--------------------------------------------------------------------------------
			//SONDERZEICHEN IN ORDNER-NAMEN UND SOMIT IM MENNAMEN ZULASSEN
			$label = char_mapping ($label);
			//--------------------------------------------------------------------------------
		
      if(chop($menubuttons) == "on")  //HAUPTMENBUTTONS
      {

        //WENN TOP-BOTTOM-MENS
        if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13" || chop($frames) == "14"
           || chop($frames) == "15" || chop($frames) == "16" || chop($frames) == "17" || chop($frames) == "18")
        {
          //TOP-BOTTOM-MEN
          $menu = "<td align=\"center\" class=\"menubuttons\">\n<b><nobr><a class=\"menulink\" href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></b></td>\n";
          $space = "<td align=\"center\">&nbsp;&nbsp;</td>";
        }
        else
        {
          //SEITENMENS
          
          //AUF GRUPPENBERSCHRIFT IM None-ORDNER UNTERSUCHEN -> FORMAT 1_None.Gruppenberschrift
          if(preg_match("/None/",$link)) //None IST NUR LEERFELD IM MEN
          {
            $groupname = explode(".",$link); //AUFSPALTEN AN .
            if(isset($groupname[2]) && !preg_match("/php/",$groupname[2]) && !preg_match("/htm/",$groupname[2]) && !preg_match("/html/",$groupname[2])) //IMMER IM 3.ARRAYELEMENT
            {
              $groupname = explode("/",$groupname[2]); //NOCHMALS AUFSPALTEN AN /
              $groupname = $groupname[0]; //SCHREIBEN
            }
            else //SONST WENN NICHT VORHANDEN
            {
              $groupname = "&nbsp;"; //LEERZEICHEN SCHREIBEN
            }
          }

          //WENN HIER VARIABLEN BERGEBEN WERDEN, MSSEN DIESE IN scan_dir UNTER 'FORM AUFBAUEN' EBENFALLS DER FORM BERGEBEN WERDEN, SONST KLAPPT DAS GANZE NICHT
          $menu = "<table width=\"100%\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr><td align=\"center\" class=\"menubuttons\">\n<b><nobr><a class=\"menulink\" href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></b></td></tr>$mLines</table>\n";
          //LEERZEICHEN
          $space = "<table width=\"100%\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr><td align=\"center\"><b>$groupname</b></td></tr>$mLines</table>\n";
          unset($groupname); //ZERSTREN
        }
        //-------------------------------------------------------------
        //EIGENTLICHE SCHREIBENDER BEREICH
        if(preg_match("/None/",$link)) //None IST NUR LEERFELD IM MEN
        {
          //STATT MENPUNKT FREIEN RAUM ANSZEIGEN
          print $space;
        }
        else
        {
          //MENPUNKT
          print $menu;
        }
      }
      else //***NORMAL-MODUS OHNE BUTTONS***
      {
        //WENN TOP-BOTTOM-MENS
        if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13" || chop($frames) == "14"
           || chop($frames) == "15" || chop($frames) == "16" || chop($frames) == "17" || chop($frames) == "18")
        {
          //TOP-BOTTOM-MEN
          $normal_menu = "<td>\n<b><nobr><a class=\"menulink\" href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></b></td>\n";
          $normal_space = "<td>&nbsp;&nbsp;</td>";
        }
        else
        {
          if(preg_match("/None/",$link)) //None IST NUR LEERFELD IM MEN
          {
            $groupname = explode(".",$link); //AUFSPALTEN AN .
            if(isset($groupname[2]) && !preg_match("/php/",$groupname[2]) && !preg_match("/htm/",$groupname[2]) && !preg_match("/html/",$groupname[2])) //IMMER IM 3.ARRAYELEMENT
            {
              $groupname = explode("/",$groupname[2]); //NOCHMALS AUFSPALTEN AN /
              $groupname = $groupname[0]; //SCHREIBEN
            }
            else //SONST WENN NICHT VORHANDEN
            {
              $groupname = "&nbsp;"; //LEERZEICHEN SCHREIBEN
            }
          }
          
            $normal_menu = "<tr><td>\n<b><nobr><a class=\"menulink\" href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></b></td></tr>$mLines\n";
            $normal_space = "<tr><td><b>$groupname</b></td></tr>\n";
            unset($groupname);
        }
         
        //-------------------------------------------------------------
        //EIGENTLICHE SCHREIBENDER BEREICH
        if(preg_match("/None/",$link)) //None IST NUR LEERFELD IM MEN
        {
           //FREIEN RAUM SCHREIBEN
           print $normal_space;
        }
        else
        {
          //NORMALER MODUS - MEN SCHREIBEN
          print $normal_menu;
        }
      }
    }
    else  //***SONST UNTERMENS***
    {
      if(chop($menusubbuttons) == "on") //UNTERMENBUTTONS
      {
				//--------------------------------------------------------------------------------
				//SONDERZEICHEN IN ORDNER-NAMEN UND SOMIT IM MENNAMEN ZULASSEN
				$label = char_mapping ($label);
				//--------------------------------------------------------------------------------
        //-----------------------------------------------------------------------------------
        //NORMALMODUS - DEAKTIVIERT, FUNKTIONIERT ZWAR MIT ABSTRICHEN, ABER NICHT SINNVOLL
        //if(chop($frames) == "10" || chop($frames) == "11")
        //{
        //   print "<td>&nbsp;</td>\n<td align=\"center\" class=\"submenubuttons\"><nobr><a href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></td>\n";
        //}
        //else
        //{
        //-----------------------------------------------------------------------------------
          if(chop($frames) != "10" && chop($frames) != "11" && chop($frames) != "12" && chop($frames) != "13" && chop($frames) != "14"
             && chop($frames) != "15" && chop($frames) != "16" && chop($frames) != "17" && chop($frames) != "18")
          {
            switch(chop($label)) //LABEL AUF EINTRAG UNTERSUCHEN
            {
              //WENN KEIN LABELEINTRAG, DANN NUR LEERE TABELLENZEILE ERZEUGEN FR MENABSTAND, SONST WIRD LEERER BUTTON ERZEUGT
              case "": print "<tr><td>&nbsp;</td></tr>"; break;
              //BUTTONS FR UNTERMENS ERZEUGEN                                                                              //ast=1& ?
              default: print "<tr><td width=\"15%\"></td>\n<td align=\"center\" class=\"submenubuttons\"><nobr><a class=\"submenulink\" href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></td></tr>\n";
                       break;
            }
          }
        //-----------------------------------------------------------------------------------
        //}
        //-----------------------------------------------------------------------------------
      }
      else //NORMALER MODUS
      {
				//--------------------------------------------------------------------------------
				//SONDERZEICHEN IN ORDNER-NAMEN UND SOMIT IM MENNAMEN ZULASSEN
				$label = char_mapping ($label);
				//--------------------------------------------------------------------------------
        //-----------------------------------------------------------------------------------
        //NORMALMODUS - DEAKTIVIERT, FUNKTIONIERT ZWAR MIT ABSTRICHEN, ABER NICHT SINNVOLL
        //if(chop($frames) == "10" || chop($frames) == "11")
        //{
        //  print "<td width=\"10\"></td>\n<td><nobr><a href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></td>\n";
        //}
        //else
        //{
        //-----------------------------------------------------------------------------------
          if(chop($frames) != "10" && chop($frames) != "11" && chop($frames) != "12" && chop($frames) != "13" && chop($frames) != "14"
             && chop($frames) != "15" && chop($frames) != "16" && chop($frames) != "17" && chop($frames) != "18")
          {
            print "<tr><td width=\"10\"></td>\n<td><nobr><a class=\"submenulink\" href=\"$link?serverroot=$root&level=$level&includeseite=core.parser.php&edit=$edit\" target=\"$target\">&nbsp;$label&nbsp;</a></nobr></td></tr>\n";
          }
        //-----------------------------------------------------------------------------------
        //}
        //-----------------------------------------------------------------------------------
      }
    }
  }

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
~ NAME: function scan_dir ($dir,$LEVEL)
~ ART: php-Script
~ ZWECK: untersucht vom Aufrufpfad (z.B. htdocs) abwrts alle Eintrge, 
*        ob diese Verzeichnisse sind  
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
  function scan_dir ($dir,$level) 
  {
    //VARIABLEN WIRD IM SERVER VORGEHALTEN
  	global $menu;  //MEN
  	global $pfad;  //PFAD - WIRD OFFENSICHTLICH NICHT IMPORTIERT BZW. BENTIGT
    global $edit;  //EDITIERMODUS
    global $frames; //FRAMEART
    global $menubuttons; //HAUPTMENBUTTONS
    global $menusubbuttons; //UNTERMENBUTTONS
    global $menurand; //MENRAND - HAUPTMEN
    global $menu2rand; //ABSTAND MENTEXT ZUM RAND - HAUPTMEN
    global $menu2menu; //ABSTNDE ZWISCHEN MENPUNKTEN - HAUPTMEN
    global $menuwidth; //TABELLENBREITE - HAUPTMEN
    global $submenurand; //MENRAND - UNTERMEN
    global $submenu2rand; //ABSTAND MENTEXT ZUM RAND - UNTERMEN
    global $submenu2menu; //ABSTNDE ZWISCHEN MENPUNKTEN - UNTERMEN
    global $submenuwidth; //TABELLENBREITE - UNTERMEN
    
    for ($i=48;$i<92;$i++) 
    {
			$handle=opendir($dir);          
			
			//-----------DYNAMISCHES SEITE ANFANG---------------------------- 
			$menucounter++;  //DURCHLAFE ZHLEN
			//MEN AB ERSTER STUFE / $menucounter -> form-TAG NUR EINMAL SCHREIBEN
			if($level>0 && $menucounter < 2) 
			{
			  $lev = $level-1;
			  
			  //FORM AUSFBAUEN
			  //**************
        //$LEVEL IST DER ZHLER FR VERZEICHNIS-/MENTIEFE - serverroot HIER MU IDENTISCH SEIN MIT $root IN FUNKTION print_link UND IN core.parser.php-INCLUDEDATEI EBENFALLS WEITERGEBE
				//WENN PER print_link WEITERE VARIABLEN BERGEBEN WERDEN, MSSEN DIESE HIER EBENFALLS ERSCHEINEN
        echo "<form name=\"menuindex$level\"><input type=\"hidden\" name=\"adresse\" value=\"$dir/index.php?serverroot=$pfad&level=$lev&includeseite=core.parser.php&edit=$edit\"></form>\n"; //DYNAMISCH GENERIERTE ADRESSE
			}                                                                                                               //$pfad WIRD IN DER JEWEILIGEN index.php AUTOMATISCH GENERIERT
			//-----------DYNAMISCHES SEITE ENDE----------------------------
			
			while (($file = readdir($handle))!==false)  //SOLANGE LAUFEN BIS KEIN UNTERVERZEICHNIS MEHR DA IST
			{
      	if (ord($file) == $i)   //UNTERSUCHEN AUF ASCII-WERT
      	{
	    		$sub="$dir/$file";  //VERZEICHNIS ZUWEISEN
	    		if ($i < 58)        //WENN KLEINER ALS 58 (Z)
	    		{
	      		$label=strtr(substr($file,2),"_"," ");    //UNTERSTRICHE IN VERZEICHNISNAMEN DURCH LEERZEICHEN FR MEN ERSETZEN
	    		} 
	    		else 
	    		{
	      		$label=strtr($file,"_"," "); //UNTERSTRICHE IN VERZEICHNISNAMEN DURCH LEERZEICHEN FR MEN ERSETZEN
	    		}
            
	    		if (is_dir($sub)) //WENN VERZEICHNIS IST
	    		{ 
  	      	if (exist_sub($sub)) //WENN VERZEICHNIS EXISTIERT
  	      	{
		  				if (file_exists("$sub/index.html") || file_exists("$sub/index.htm") || file_exists("$sub/index.php"))   //WENN EINER DER DATEIEN EXISTIERT IM VERZEICHNIS
		  				{
		    				$request="menu=$sub&link=$sub/index.php"; //MENLINK AUFBAUEN MIT UNTERMEN
		    				//$request="$sub/index.php";
		  				}
		  				else 
		  				{
		    				$request="menu=$sub"; //SONST NUR MEN DER ERSTEN EBENE
		    				//$request=$sub;
		  				}
	    		    //-------------------------------------------------------------
	    		    //MEN SCHREIBEN
		  				print_link ("core.menu.php?$request",$label,$level,$sub);  //MEN SCHREIBEN
              
		  				if (strstr($menu,$sub))  //WENN SUB IN MENU VORHANDEN IST
		  				{
		    				if ($level > 0)    //WENN LEVEL (VERZEICHNISEBENE) GRER 0 IST
		    				{ 
		    					print "<tr><td width=10></td><td>";   //TABELLENZEILE SCHREIBEN
		    				}
		          
		            //-------------------------------------------------------------
		            //NOTWENDIG, DAMIT BEI TOP-, BOTTOM-MENS BEI
		            //DUMMYORDNER IM MENPUNKT DIE UMBROCHENEN MENS ALS BUTTON DARGESTELLT WERDEN
		            //ANSONSTEN SIND IN DIESEM MODUS UNTERMENS DEAKTIVIERT
		            if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13"
                    || chop($frames) == "14"  || chop($frames) == "15"  || chop($frames) == "16"  || chop($frames) == "17"
                     || chop($frames) == "18") //WENN MEN OBEN ODER UNTEN IST
                {
                  $tr_close_sub = "</tr>";
                  $table_open_main = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr>";
                }
                else
                {
                  //LEVEL 0 IST HAUPTMEN, DAMIT NICHT DAS HAUPTMEN UNTER DEM UNTERMEN NICHT WIE UNTERMEN EINGERCKT WIRD
                  //UND SOLL AUCH FUNKTIONIEREN IM NORMAL (BUTTONLOSEN) MODUS, DA IM BUTTONMODUS JEDER BUTTON ZUSTZLICHE
                  //TABELLE IST UND IM NORMALMODUS ALLES IN EINER TABELLE ABGEFACKELT WIRD UND DAS UNTERMEN FAST RECHTS
                  //VERSCHWINDET
                  if($level==0 && (chop($menubuttons) == "off" || chop($submenubuttons) == "off"))
                  {
                    $table_open_main = "<table width=\"$menuwidth\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr>";
                  }
                }
                //-------------------------------------------------------------

		    				print "<table width=\"$submenuwidth\" cellspacing=\"$submenu2menu\" cellpadding=\"$submenu2rand\" border=\"$submenurand\">\n";  //TABELLE FFNEN  WEITER
		    				scan_dir("$sub",$level+1);                             //NACH WEITEREN UNTERVERZEICHNISSEN SCANNEN
		    				print "$tr_close_sub</table>$table_open_main<font size=\"1\">"; //TABELLE SCHLIEEN
		    				$level < 1 ? print"<br>" : print "";  //ZEILENUMBRUCH AB BESTIMMTER MENTIEFE VERHINDERN, DAMIT ABSTAND SICH NICHT POTENTIERT - WERT 2 AUCH OK
		    				print "</font>\n";          //TABELLE SCHLIEEN
		    				
		    				if ($level > 0)  //WENN LEVEL > 0 IST
		    				{ 
		    					print "</td></tr>";   //TABELLENZEILE SCHLIEEN
		    				}
		    				
		  				}
	      		} 
	      		else 
	      		{    
        			print_link("$sub/index.php",$label,$level,$sub,"rechter");   //LINK FR UNTERVERZEICHNIS SCHREIBEN
        			//print_link("$sub",$label,$level,"rechter");   //LINK FR UNTERVERZEICHNIS SCHREIBEN - OHNE index.php -> APACHE-FUNKTIONALITT WIRD GENUTZT
	      		} 
	      		
	    		}       //is_file  
	    		elseif (is_dir($sub) && (no_index($file)) && ($level > 0))  //WENN SUB DATEI IST && KEIN INDEX HAT UND LEVEL > 0
	    		{
          	print_link("$sub/index.php",substr($label,0,strpos($label,".")),$level,$sub,"rechter");  //LINK FR UNTERVERZEICHNIS SCHREIBEN
          	//print_link("$sub",substr($label,0,strpos($label,".")),$level,"rechter");  //LINK FR UNTERVERZEICHNIS SCHREIBEN - OHNE index.php -> APACHE-FUNKTIONALITT WIRD GENUTZT
	    		}    		
	  		}      
			}
			closedir($handle);  //VERZEICHNIS SCHLIESSEN
    }
  }


/************************************************************
* HAUPTPROGRAMM
************************************************************/
$css = $pfad . $stylepfad . "/core.menu.css";  //CSS-DATEI AUS DEM STYLE-VERZEICHNIS HOLEN

echo <<< HTMLBASIS
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
 <html>   
 	<head>
 		<title>AT Contenator - Men</title>
 		<link rel="stylesheet" type="text/css" href="$css">
 	  
 	  <!-----------DYNAMISCHES SEITE ANFANG---------------------------->
 	  <script type="text/javascript">
		<!--  
			window.onerror = fehler;  //ZUWEISUNG DER FUNKTION FR FEHLERBEHANDLUNG
			
			/********************************************************************
			~ NAME: function fehler()
			~ ART: Javascript
			~ ZWECK: ermglicht ein notwendiges Fehlerhandling und schaltet
			~        somit einen mglichen Fehlerdialog von Javascript aus
			~ BEMERKUNG: Die Zuwesiung dieser Funktion erfolgt zu window.onerror
			~            window.onerror = fehler;
			********************************************************************/
			function fehler()
			{
				return true;     //GIBT NUR TRUE ZURCK, TUT ALSO NICHTS, IST ABER NOTWENDIG, SONST ERSCHEINT FEHLERDIALOG UND DAS SOLL NICHT SEIN
			}
			
			/********************************************************************
			~ NAME: function anzeigen()
			~ ART: Javascript
			~ ZWECK: ermglicht das gleichzeitige Ausklappen eines Menpunktes
			~        und Anzeige einer dazu passenden Seite in einem Frameset
			~        bis zu einer beliebigen Verzeichnistiefe (und damit auch 
			~        Die entsprechende Anzahl der Untermens) 
			~ BEMERKUNG: kann beliebig in der Anzahl der Untermens erweitert werden
			********************************************************************/
			function anzeigen() 
			{ 
				//ANZEIGEN DER SEITE - LT NUR DIE ANZEIGE IN 10 UNTERMEN GLEICHZEITIG MIT WEITEREN MENPUNKTEN ZU - KANN BELIEBIG ERWEITERT WERDEN
				parent.rechter.location.href = document.forms["menuindex1"].adresse.value; //ZEIGT DYNAMISCH GENERIERTE ADRESSE AN
				parent.rechter.location.href = document.forms["menuindex2"].adresse.value;
				parent.rechter.location.href = document.forms["menuindex3"].adresse.value;
				parent.rechter.location.href = document.forms["menuindex4"].adresse.value;
				parent.rechter.location.href = document.forms["menuindex5"].adresse.value;
				parent.rechter.location.href = document.forms["menuindex6"].adresse.value;
        parent.rechter.location.href = document.forms["menuindex7"].adresse.value;
        parent.rechter.location.href = document.forms["menuindex8"].adresse.value;
        parent.rechter.location.href = document.forms["menuindex9"].adresse.value;
        parent.rechter.location.href = document.forms["menuindex10"].adresse.value;
				//...DURCH KOPIEREN NACH UNTEN UND ERHHEN DER ZAHL ERWEITERBAR ...
			}
		//-->
		</script>
    <!-----------DYNAMISCHES SEITE ANFANG---------------------------->
    <meta name="Generator" content="AT Contenator">
    <meta http-equiv="expires" content="0">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
 	</head>
<body onload="anzeigen()">  <!--LDT DYNAMISCH GENERIERTE ADRESSE-->
<!-- <body bgcolor="white"> --> <!--NUR DANN, WENN APACHE-FUNKTIONALITT FR VERZEICHNISANZEIGE GENUTZT WIRD-->
HTMLBASIS;
//------------------------------------------------------------------------

//TABELLE FFNEN
if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13" || chop($frames) == "14"
   || chop($frames) == "15" || chop($frames) == "16" || chop($frames) == "17" || chop($frames) == "18")
{
  print "<table width=\"100%\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\">\n"; //HAUPTMENS TOP UND BOTTOM
}
else
{
  //SEITEN HAUPTMENS
  if(chop($menubuttons) == "on")
  {
    //KEINEN RAND -> DA BUTTONS JEWEILS EIGENE TABELL MIT RAND HABEN
    print "<table width=\"$menuwidth\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td>\n";
  }
  else
  {
    //OHNE BUTTONS ABER RAND MGLICH
    print "<table width=\"$menuwidth\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr><td>\n";
  }
}

//SCHNUFFLODONDRON EINBINDEN
$schnufflodondron = config_read("schnufflodondron","_config");  //KONFIGURATION HOLEN

if(chop($schnufflodondron) == "on")
{
  //BUTTONMODUS
  if(chop($menubuttons) == "on")
  {
    //BEI TOP-BOTTOM-MENS
    if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13" || chop($frames) == "14"
       || chop($frames) == "15" || chop($frames) == "16" || chop($frames) == "17" || chop($frames) == "18") //WENN MEN OBEN ODER UNTEN IST
    {
      $schnufflo = "<td align=\"center\" class=\"menubuttons\">\n<nobr><a class=\"menulink\" href=\"core.schnufflodondron.php\" target=\"_blank\">&nbsp;Schnufflo-Suche&nbsp;</a></nobr></td>";
    }
    else //BEI SEITENMENS
    {
      echo "<table width=\"100%\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr><td align=\"center\" class=\"menubuttons\">\n<nobr><a class=\"menulink\" href=\"core.schnufflodondron.php\" target=\"_blank\">&nbsp;Schnufflo-Suche&nbsp;</a></nobr></td></tr>$mLines</table>";
    }
  }
  else //NORMALER MODUS
  {
    //BEI TOP-BOTTOM-MENS
    if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13" || chop($frames) == "14"
       || chop($frames) == "15" || chop($frames) == "16" || chop($frames) == "17" || chop($frames) == "18") //WENN MEN OBEN ODER UNTEN IST
    {
      $schnufflo = "<td><a class=\"menulink\" href=\"core.schnufflodondron.php\" target=\"_blank\">&nbsp;Schnufflo-Suche&nbsp;</a></td>";
    }
    else
    {
      //SEITENMEN
      echo "<a class=\"menulink\" href=\"core.schnufflodondron.php\" target=\"_blank\">&nbsp;Schnufflo-Suche&nbsp;</a></td></tr>$mLines";
    }
  }
}
//------------------------------------------------------------------------
//LINK FR HOME ERZEUGEN
$home = config_read("home","_config");  //KONFIGURATION HOLEN

if(chop($home) > "")
{
//BUTTONMODUS
  if(chop($menubuttons) == "on")
  {
    //TOP-BOTTOM-MEN
    if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13" || chop($frames) == "14"
       || chop($frames) == "15" || chop($frames) == "16" || chop($frames) == "17" || chop($frames) == "18") //WENN MEN OBEN ODER UNTEN IST
    {
      $td_close = "</tr>"; //NOTWENDIG, DAMIT ZEILE KORREKT GESCHLOSSEN WIRD
      echo "<table width=\"100%\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr><td align=\"center\" class=\"menubuttons\">\n<b><nobr>
            <a class=\"menulink\" href=\"$home?edit=$edit\" target=\"rechter\">&nbsp;Home&nbsp;</a></nobr></b></td>";
    }
    else  //SONST SEITENMEN
    {
      echo "<table width=\"100%\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr><td align=\"center\" class=\"menubuttons\">\n<b><nobr>
            <a class=\"menulink\" href=\"$home?edit=$edit\" target=\"rechter\">&nbsp;Home&nbsp;</a></nobr></b></td></tr>$mLines</table>";
    }
  }
  else //NORMALER MODUS
  {
    //TOP-BOTTOM-MEN
    if(chop($frames) == "10" || chop($frames) == "11" || chop($frames) == "12" || chop($frames) == "13" || chop($frames) == "14"
       || chop($frames) == "15" || chop($frames) == "16" || chop($frames) == "17" || chop($frames) == "18") //WENN MEN OBEN ODER UNTEN IST
    {
      $td_close = "</tr>"; //NOTWENDIG, DAMIT ZEILE KORREKT GESCHLOSSEN WIRD
      echo "<tr><td><b><nobr><a class=\"menulink\" href=\"$home?edit=$edit\" target=\"rechter\">&nbsp;Home&nbsp;</a></nobr></b></td>";
    }
    else
    {
      //SEITENMEN
      echo "<tr><td><b><nobr><a class=\"menulink\" href=\"$home?edit=$edit\" target=\"rechter\">&nbsp;Home&nbsp;</a></nobr></b></td></tr>$mLines\n";
    }
  }
}
else
{
  $td_tr_close = "</td></tr>"; //NOTWENDIG, DAMIT ZEILE KORREKT GESCHLOSSEN WIRD
  //echo "<table width=\"80%\" cellspacing=\"$menu2menu\" cellpadding=\"$menu2rand\" border=\"$menurand\"><tr>"; //TABELLE FFNEN, DAMIT ABSTNDE ZWISCHEN BUTTONS GESETZT WERDEN
}

//------------------------------------------------------------------------
 //print "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\">\n";  //TABELLE FFNEN
 scan_dir(".",0); //AUFRUF DER VERZEICHNISPRFUNG ZUR MENERZEUGUNG
 print "$schnufflo$td_tr_close</table>";  //TABELLE SCHLIESSEN

//#########################################################################
//INTERFACE - ANFANG
//AUF MODULE UNTERSUCHEN UND EINBINDEN - PLUG-IN-INTERFACE
$moduleview = config_read("menumodule","_config");  //KONFIGURATION FR MODULANZEIGE HOLEN
$moduletitel = config_read("moduletitel","_config");  //KONFIGURATION FR MODULTITEL HOLEN

//BEI TOP-, BOTTOM-MENS KEINE MENMODULE
if(chop($frames) != "10" && chop($frames) != "11" && chop($frames) != "12" && chop($frames) != "13" && chop($frames) != "14"
   && chop($frames) != "15" && chop($frames) != "16" && chop($frames) != "17" && chop($frames) != "18")
{
  //WENN MODULE AUF on
  if(chop($moduleview) == "on")
  {
    echo "<br><div class=\"menumodules\">";
    //---------------------------------------------------
    //MODULTITEL
    if(chop($moduletitel) > "")                 //WENN MODULTITEL VORHANDEN IST
    {
      echo "<b>&nbsp;$moduletitel</b><br>";     //ANZEIGEN
    }
    //---------------------------------------------------
    //MODULE SUCHEN
    $verz=opendir (".");												//AKTUELLES VERZEICHNIS FFNEN

    while ($file = readdir ($verz)) 						//JEDEN EINTRAG LESEN
    {     //echo $file."<br>";
		  if(is_file($file) && preg_match("/module/",$file)) //AUCH WENN $file EIN VERZEICHNIS IST
		  {
			  $module = explode(".",$file);
			  echo "&nbsp;&nbsp;<a href=\"$file\" target=\"$module[2]\">&nbsp;$module[1]&nbsp;</a><br>";
			  $m = true;	
		  }
    }

    closedir($verz);
    //---------------------------------------------------
    //WENN KEINE MODULE INSTALLIERT SIND
    if(!$m) { echo "&nbsp;&nbsp;Keine Module installiert!"; }
    echo "</div>";
  }

  //INTERFACE - ENDE
  //#########################################################################
  //LIZENZ
  echo "<br><div class=\"lizenz\"><a href=\"http://contenator.ansatheus.de\" target=\"_blank\">&nbsp;<i>powered by</i>&nbsp;&nbsp;AT Contenator&nbsp;</a><br>";
  echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"gnu_gpl.htm\" target=\"_blank\">&nbsp;- Lizenz -&nbsp;</a>";
  echo "<p><font size=\"1\" face=\"Tahoma,Arial,Helvetica\"> Ansatheus - 2003-2014</font></div>";
}
else
{
  echo "<a href=\"http://contenator.ansatheus.de\" target=\"_blank\">&nbsp;<i>powered by</i>&nbsp;&nbsp;AT Contenator&nbsp;</a>";
}
 echo "</body></html>";

 
?>

