<?php
/************************************************************
~ AUTOR Andreas Theusner  2003
~  - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: Menmodul fr AT Contenator
~ DATEI: core.counter.php
~ ZWECK: erzeugt eine Sitemap fr eine AT-Contenator-Website
~ BEMERKUNGEN:
~   Aufgrund der Besonderheiten bei der Mengenerierung des
~   Contenators wurde hier auf eine rekursive Generierung
~   der Verzeichnisse als Sitmap verzichtet. Stattdessen
~   wurde hier direkt addressiert (Hardcore-Programmierung).
~   D.h. es wurde von Hand geschachtelt. Eine Sitemap kann
~   bis zu einer Tiefe von max. 10 Untermens generiert werden.
~   Wer es noch mehr mag, der kann die Verschachtelung per
~   Hand bis zu beliebiger Gre weiterfhren.
~   Sollte das jemand tun wollen, so mu er die absoluten
~   Pfadangaben (deren Inhalte aber variabel sind und von
~   den Verzeichnisnamen abhngen) weiternummerieren. Wichtig
~   ist der Inhalt der Variable $level, weil jede index.php
~   in den Verzeichnissen diese bentigt, um den Pfad zum
~   Parser im Root (Mitgabe per Variable $parser) automatisch
~   zu generieren.
~   Die Ausgabe der Verzeichnisse im entsprechenden Baum in
~   der Sitemap erfolgt unsortiert. Das ist leider eine
~   Einschrnkung der genutzten PHP-Funktion readdir().
~************************************************************

~************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
~************************************************************
~ Ein kleiner Counter
~ Damit es funktioniert:
~  - core.config.dat mu im Root des Contenators bzw. der Seite
~    vorhanden sein, auf der gezhlt werden soll
~  - aktuellste core.menu.php
~  - sie sollte Berechtigungen fr alle haben (Linux chmod 777)
~  - Reloadsperre in core.main.php bzw. der index.php in einem
~    Verzeichnis wie folgt:
~
~        if(!$nocount)
~        {
~          $modus = "count";
~          include_once("core.counter.php"); //ZHLER AUSFHREN
~        }
~        else
~        {
~          $modus = "nocount";
~          include_once("core.counter.php"); //ZHLER AUSFHREN
~        }
~
~  - obige Reloadsperre greift nicht beim erneuten Laden der
~    Seite durch den Browser, sondern nur ber die Navigation der
~    der Seite
~  - wird index_nocount.php aufgerufen, dann wird eine generelle
~    Reloadsperre aufgerufen
~
~  Modus:
~    - count -> zhlen und anzeigen (Standard)
~    - nocount -> nur anzeigen
~************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

function zaehler($mode="count")
{
  $counterfile = "_daten/core.counter.dat";           //DATEI
  $counter_array = @file($counterfile,"r");    //DATEI IM LESE- UND SCHREIBMODUS ERZEUGEN

  //MODUS
  switch($mode)
  {
    case "count":   $counter = (int) $counter_array[0];          //WERT AUS AEEAY HOLEN UND PER TYPECAST IN INTEGER KONVERTIEREN
                    $counter++;                                  //HOCHZHLEN
                    $counter_file = fopen($counterfile,"w+");  	 //DATEI IM LESE- UND SCHREIBMODUS NEU ERZEUGEN
                    fputs($counter_file,$counter);   						 //WERT IN DIE DATEI SCHREIBEN
                    fclose($counter_file);                       //DATEI SCHLIESSEN
                    break;
    case "nocount": $counter = (int) $counter_array[0];          //NUR WERT AUS AEEAY HOLEN UND PER TYPECAST IN INTEGER KONVERTIEREN
                    break;
    default: break;
  }
  
  return $counter;                             //WERT ZURCKGEBEN
  
}

//AUSGABE DES ZHLERSTANDES - KANN FORMATIERT WERDEN
echo "<center><b>Besucher bisher:<br>" . zaehler($modus) . "</b></center>";
?>
