<?php
/**********************************************************************************************
~ AUTOR: Andreas Theusner,  2003 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator
~ DATEI: core.config.php
~ ZWECK: enthlt Funktionen zur Konfiguration von AT Contenator
~	AUFRUF:					- Konfiguration
~                 - Include-Datei fr andere Skripte
~                 $variable = config_read($configbereich,$configpfad,$configdatei)
~                 $configbereich = ist der Abschnitt in der Konfigurationsdatei
~                 $configpfad = ist der Pfad zur Konfigurationsdatei -> .htaccess-geschtzt im
~                               Unterverzeichnis _config, das Konfigurationsverzeichnis
~                               kann berschrieben werden - optional
~                 $configdatei = Datei, die die Konfiguration enthlt, die Konfigurationsdatei
~                                kann berschrieben werden, z.B. wenn fr Module andere
~                                Konfigurationsdateien genutzt werden sollen - optional
~ STATUS:					einsatzfhig
~ HINWEIS:        detaillierte Kommentare befinden sich im Quellcode
**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
~ NAME: function config_read($configbereich,$configpfad,$configdatei,$configtrenner)
~ ART: php-Script
~ ZWECK: Liest die Konfiguration aus beliebigen Konfigurationsdateien fr den
~        $configbereich aus und gibt die Konfiguarion zurck
~ BEMERKUNG: $configbereich = Name der Option
~            $configpfad = Pfad zur Konfigurationsdatei
~            $configdatei = Name der Konfigurationsdatei                    
~            $configtrenner = Zeichenfolge, durch die $configbereich und Wert getrennt wird
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

function config_read($configbereich,$configpfad="_config",$configdatei="core.config.dat",$configtrenner="=")
{
  //KONFIGURATION EINLESEN
  $config = @file("$configpfad/$configdatei");

  if(is_array($config))
  {
   //ARRAY DURCHLAUFEN
   foreach($config as $v)
   {
     if(substr($v,0,1) != "#")  //ZEILE MIT DIESEM ERSTEM ZEICHEN BERSPRINGEN
     {
       $conf = explode($configtrenner,$v);         //AUFSPALTEN
       if($conf[0] == $configbereich)   //VERGLEICHEN
       {
         return $conf[1];               //ZURCKGEBEN
       }
     }
   }
  }
}
?>
