<?php
/**********************************************************************************************
~ AUTOR: Andreas Theusner,  2009 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator
~ DATEI: modul.ordner.docunator_funktionen.php
~ ZWECK: - enthlt Funktionen fr den Docunator
/**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
/*******************************************************************************************
~ AUTOR: 	Andreas Theusner , 18.05.2009
~ ZWECK: 	rekursives Auslesen aller Dateien und Verzeichnisse ab Startverzeichnis
~         und Ausgabe als Links
~ FUNKTIONALITT:
~		$dir = Startverzeichnis - alle Verzeichnisse darunter werden rekursiv durchsucht
~		$ausgabe = Ausgabe in den Browser - Trick zur Ermittlung der Anzahl der Fundstellen
~							 wenn zuerst false - Rckgabe der Trefferanzahl - dann true, wird zuerst
~							 die Trefferanzahl ermittelt und dann werden die Treffer ausgegeben
~							 - kaum merklich langsamer
~ BEMERKUNG: Grundgerst aus dem Internet
*******************************************************************************************/
//BEI ABGESCHALTETEM register_globals
import_request_variables("CPG","");

require_once("modul.ordner.docunator_config.php");
$trefferall = 0; //GLOBALE VARIABLE INITIALISIEREN
$count = 0;
$level = 0;
$slash = slash_by_os();
$datei_array[] = ""; //ARRAY MU GLOBAL SEIN, SONST WERDEN IMMER NUR DIE DATEIEN EINES DURCHLAUFES GESPEICHERT, NIE ALLE

/*******************************************************************************************
~ AUTOR: 	Andreas Theusner , 05.06.2009
~ ZWECK: 	durchluft Verzeichnis rekursiv und liest alle Datei in Array und gibt es zurck
~ FUNKTIONALITT:
~            $dir = startverzeichnis
~            $ausgabe = Verzeichnis in die Seite schreiben
~ AUFRUF: $success = CopyDirectory(Quellverzeichnis, Zielverzeichnis);
~ BEMERKUNG: Grundgerst aus dem Internet
*******************************************************************************************/
function all_dir_files ($dir,$ausgabe=true)
{
  	global $trefferall;					//GLOABALE VARIABLE IMPORTIEREN
    global $count;
    //global $level;
    global $datei_array;
    global $slash;
    
    $level = 0;
		$fp=opendir($dir);         	//VERZEICHNIS FFNEN
		while($datei=readdir($fp))  //ALLE EINTRGE IN DIESEM VERZEICHNIS AUSLESEN
    {
			if (is_dir("$dir/$datei") && $datei != "." && $datei != "..")   //WENN VERZEICHNIS UND NICHT . ODER ..
      {
      	$trefferall++; //TREFFER HOCHZHLEN
        $level++;

        if($ausgabe)	//NUR WENN AUSGABE TRUE IST
        {	 //SOLLTE DEAKTIVIERT SEIN, DA BEI DEN VERZEICHNISSEN MIT index.php VON AT CMS FEHLER AUSGEGEBEN WERDEN WEGEN INCLUDE DES PARSERS
           //SIEHE IN schnufflodondron.php UNTER $nur_verzeichnisse AUSGEBEN
      		//echo "<font size=2><a href=\"$dir/$datei\"><b>$dir/$datei</b></a>$edit</font><br>";   //VERZEICHNIS ALS LINK GENERIERT AUSGEBEN
        }
        
//        echo "LEVEL: $level<br>";
//        if($level = 1)
//        {
//           echo $dir . $datei . "<br>";
//        }
//        else
//        {
//          echo $dir ."/". $datei . "<br>";
        //}
        
        
        //echo "DIR: $dir<br>";
        //echo "DATEI: $datei<p>";
//        echo $dir.$slash.$datei;
      	all_dir_files($dir.$slash.$datei,$ausgabe);	//REKURSIVER AUFRUF DER FUNKTION ZUM ERNEUTEN DURCHLAUFEN DES NCHSTEN UNTERVERZEICHNISSES
        //$datei_array[$trefferall] = "VERZEICHNIS: ".$dir.$datei;
      }
			else //SONST IST ES EINE DATEI
      {
        if($datei != "." && $datei != "..") 	//WENN NICHT . UND .. ANDERE DATEIEN UND KEINE PHP-DATEIEN AUSSCHLIE?EN
        {
        	$trefferall++; //TREFFER HOCHZHLEN
          //echo "DATEI: $datei<br>";
//          echo "LEVEL: $level<br>";
          //UNTERSUCHT DIE DATEITIEFE - BEI 0 IST ES DER ROOT UND ES DARF KEIN SLASH [/] GESETZT WERDEN
//          if($level == 0)
//          {
//            $datei_array[$count] = $dir.$datei;
//            echo $dir."/".$datei." - ";
//          }
//          else
//          {
            $datei_array[$count] = $dir.$slash.$datei;
//            echo $dir.$slash.$datei."<br>\n";
//            echo $dir."/".$datei." - ";
//          }
          $count++;
        }
        
        
      }
		}

    closedir($fp);              //VERZEICHNIS SCHLIEEN
//var_dump($datei_array);
    return $datei_array;        //RCKGABE
    
}

/*******************************************************************************************
~ AUTOR: 	Andreas Theusner , 05.06.2009
~ ZWECK: 	kopiert komplette Verzeichnisse samt Inhalt
~ FUNKTIONALITT:
~		$SourceDirectory = Quellverzeichnis
~		$TargetDirectory = Zielverzeichnis
~ AUFRUF: $success = CopyDirectory(Quellverzeichnis, Zielverzeichnis);
~ BEMERKUNG: Grundgerst aus dem Internet
*******************************************************************************************/
function CopyDirectory($SourceDirectory, $TargetDirectory)
{
  global $slash;

  //SLASH QUELLVERZEICHNIS ANHNGEN
  if (substr($SourceDirectory,-1) != $slash)
  {
    $SourceDirectory .= $slash;
  }

  //SLASH ZIELVERZEICHNIS ANHNGEN
  if (substr($TargetDirectory,-1) != $slash)
  {
    $TargetDirectory .= $slash;
  }

  //QUELLVERZEICHNIS FFNEN
  $handle = @opendir($SourceDirectory);
  if (!$handle)
  {
    die("Das Verzeichnis $SourceDirectory konnte nicht geffnet werden.");
  }

  //ZIELVERZEICHNIS FFNEN UND BERECHTIGUNG SETZEN
  if (!is_dir($TargetDirectory))
  {
    mkdir($TargetDirectory);
    @chmod($TargetDirectory, 0755); //NUR LINUX, UNIX, MAC
  }

  //QUELLVERZEICHNIS DURCHLAUFEN UND IN DAS ZIELVERZEICHNIS KOPIEREN
  while ($entry = readdir($handle) )
  {
    if ($entry[0] == '.')
    {
      continue;
    }

    if (is_dir($SourceDirectory.$entry))
    {
      //WENN UNTERVERZEICHNIS, FUNKTION REKURSIV ERNEUT AUFRUFEN
      $success = CopyDirectory($SourceDirectory.$entry, $TargetDirectory.$entry);
    }
    else
    {
      //SONST INHALT KOPIEREN UND BERECHTIGUNG SETZEN
      $target = $TargetDirectory.$entry;
      copy($SourceDirectory.$entry, $target);
      @chmod($target, 0755); //NUR LINUX, UNIX, MAC
    }
  }

  return true;  //BEI ERFOLG TRUE ZURCKGEBEN
}


?>
