<?php
/**********************************************************************************************
~ AUTOR: Andreas Theusner,  2009 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator
~ DATEI: modul.ordner.docunator_class_html.php
~ ZWECK: - HTML-Klasse fr die Erzeugung der Dokumentation
~ EINBINDUNG: require_once("modul.ordner.docunator_class_html.php");
~             $html = new html; - neue Instanz
~ WICHTIG: durch obige Einbindung erfolgt die Initialisierung der Klasse, die wichtig ist, denn
~          der direkte Aufruf der Funktionen klappt nicht immer
~ FUNKTIONSAUFRUF: alle beschriebenen Aufrufarten gelten fr alle Funktionen, auer dem Konstruktor
~             $ergebnis = $html->function(Parameter) - Instanz
~             $ergebnis = html::function(Parameter) - direkt
~		          $ergebnis = $this->function(Parameter) - in der Klasse
/**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
class html
{

  /*******************************************************************************************
  ~ NAME:   function html()
  ~ ZWECK: 	Konstruktor der Klasse
  ~ AUTOR: 	Andreas Theusner , 18.05.2009
  ~ AUFRUF:
  ~ PARAMETER:
  ~ FUNKTIONALITT:
  ~ STATUS:
  ~ BEMERKUNG:
  *******************************************************************************************/
  function html()
  {

  }

   /********************************************************************************************
  ~ NAME: function header($title="Docunator",$rueckgabe = False)
  ~ ZWECK: generiert den Kopf eines HTML-Dokumentes
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER:
  ~   $title = Titel der Website
  ~   $rueckgabe = True/False -> wenn True, werden die Daten zurckgegeben, ansonsten geschrieben
  ~ BEMERKUNG: - heredoc-Syntax mu an erster Zeile anfangen und enden, deshalb diese Struktur
  ~            - hinter dem schlieenden heredoc-Tag darf hinter dem Semikolon keine Leerzeichen
	~              mehr sein, sonst funktioniert das Ganze nicht
  ********************************************************************************************/
   function header($title="Dokumentation mit Docunator",$rueckgabe = False,$CSS="/verzeichnis.index.css")
   {
   	   //global $css_style; //QUASIEXPORT DES INHALTES DIESER VARIABLEN
			 //$css_style = config_read("stylepfad");
			//echo "STYLE: $css_style";
			global $CONF_STYLEPFAD;

      $CONF_STYLEPFAD_LOCAL = $CONF_STYLEPFAD."/".$CSS;
      unset($CONF_STYLEPFAD);

$kopf = <<<KOPF
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
	<html>
		<head>
			<title>$title</title>
      <meta name="keywords" content="AT Contenator - WebSchnuffel - Docunator - phpDoc">
      <meta name="description" content="AT Contenator - WebSchnuffel - Docunator - phpDoc">
      <meta name="author" content="ansatheus">
      <meta name="copyright" content="ansatheus">
			<meta name="Generator" content="AT Contenator - WebSchnuffel  - Docunator">
      <meta http-equiv="expires" content="0">
      <meta http-equiv="pragma" content="no-cache">
      <meta http-equiv="cache-control" content="no-cache">
      <meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
			<link rel="stylesheet" type="text/css" href="$CONF_STYLEPFAD_LOCAL">
			<!--<script language="JavaScript1.1" type="text/javascript" src="_js/funktionen.js"></script>-->
		</head>
	<body>
KOPF;

     //ZURCKGEBEN ODER SCHREIBEN
     if($rueckgabe)
     {
       return $kopf;
     }
     else
     {
       echo $kopf;
     }
   }

  /********************************************************************************************
  ~ NAME: function footer(,$rueckgabe = False)
  ~ ZWECK: generiert den Fu eines HTML-Dokumentes
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER: $rueckgabe = True/False -> wenn True, werden die Daten zurckgegeben, ansonsten geschrieben
  ~ BEMERKUNG: - heredoc-Syntax mu an erster Zeile anfangen und enden, deshalb diese Struktur
  ~            - hinter dem schlieenden heredoc-Tag darf hinter dem Semikolon keine Leerzeichen
	~              mehr sein, sonst funktioniert das Ganze nicht
  ********************************************************************************************/
   function footer($rueckgabe = False)
   {
$fuss = <<< FUSS
    <!--<center><script language="JavaScript1.2" type="text/javascript" src="_js/footer.js"></script></center>-->
	</body>
</html>
FUSS;

     //ZURCKGEBEN ODER SCHREIBEN
     if($rueckgabe)
     {
       return $fuss;
     }
     else
     {
       echo $fuss;
     }
   }
   
  /*******************************************************************************************
  ~ NAME:   function frameset($dateilinks, $dateirechts, $title="Docunator",$rueckgabe = False)
  ~ ZWECK: 	Frameset generieren
  ~ AUTOR: 	Andreas Theusner , 22.05.2009
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER:
  ~   $dateilinks = linker Rahmen - in der Regel das Men
  ~   $dateirechts = rechter Rahmen - in der Regel der Inhalt
  ~   $title = Titel der Dokumentation
  ~   $rueckgabe = True/False -> wenn True, werden die Daten zurckgegeben, ansonsten geschrieben
  ~ FUNKTIONALITT:
  ~ STATUS:
  ~ BEMERKUNG:
  *******************************************************************************************/
  function frameset($dateilinks, $dateirechts, $title="Docunator",$rueckgabe = False)
  {
$frameset = <<< FRAMESET
<html><head><title>$title</title></head>
<frameset border="0" cols="25%,75%" scrolling="auto" frameborder="no" border="0" framespacing="0">
	<frame src="$dateilinks" name="left">
  <frame src="$dateirechts" name="right">
</frameset>
<body>
</body>
</html>
FRAMESET;

    //ZURCKGEBEN ODER SCHREIBEN
     if($rueckgabe)
     {
       return $frameset;
     }
     else
     {
       echo $frameset;
     }
  }

  /*******************************************************************************************
  ~ NAME:   function form_quelle_ziel()
  ~ ZWECK: 	Form fr Auswahl von Quelle der Dateien und Ziel fr die Ausgabe der Dokumentation
  ~ AUTOR: 	Andreas Theusner , 18.05.2009
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER:
  ~ FUNKTIONALITT:
  ~ STATUS:
  ~ BEMERKUNG:
  *******************************************************************************************/
  function form_quelle_ziel()
  {
    global $quelle;
    global $ziel;

echo <<< AUSGABE
    <form action="$PHP_SELF" name="form_quelle_ziel" method="post" enctype="multipart/form-data">
      <table border="0" cellpadding="1" cellspacing="1">
        <tr>
          <td align="right">
            Quellverzeichnis
          </td>
          <td align="left">
            <input type="text" name="quelle" value="$quelle" size="100">
          </td>
        </tr>
        <tr>
          <td align="right">
            Zielverzeichnis
          </td>
          <td align="left">
            <input type="text" name="ziel" value="$ziel" size="100">
          </td>
        </tr>
        <tr>
          <td colspan="2" align="center">
            <input type="reset" name="reset" value="Zurcksetzen">
            <input type="submit" name="generate" value="Dokumentation generieren">
          </td>
        </tr>
      </table>
    </form>
AUSGABE;
  }
}
?>
