<?php
/**********************************************************************************************
~ AUTOR: Andreas Theusner,  2009 - ansatheus@gmx.net - http://www.ansatheus.de
~ PROGRAMM: AT Contenator
~ DATEI: modul.ordner.docunator_class_docgenerate.php
~ ZWECK: - Klasse fr die Erzeugung der Dokumentation - erbt von der HTML-Klasse
~ EINBINDUNG: require_once("modul.ordner.docunator_class_docgenerate.php");
~             $html = new html; - neue Instanz
~ WICHTIG: durch obige Einbindung erfolgt die Initialisierung der Klasse, die wichtig ist, denn
~          der direkte Aufruf der Funktionen klappt nicht immer
~ FUNKTIONSAUFRUF: alle beschriebenen Aufrufarten gelten fr alle Funktionen, auer dem Konstruktor
~             $ergebnis = $docgenerate->function(Parameter) - Instanz
~             $ergebnis = docgenerate::function(Parameter) - direkt
~		          $ergebnis = $this->function(Parameter) - in der Klasse
/**********************************************************************************************
~ LIZENZ: GNU General Public License
~ Dieses Programm ist freie Software. Sie knnen es unter den
~ Bedingungen der GNU General Public License, wie von der Free
~ Software Foundation verffentlicht, weitergeben und/oder
~ modifizieren, entweder gem Version 2 der Lizenz
~ Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
~ da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
~ sogar ohne die implizite Garantie der MARKTREIFE oder der
~ VERWENDBARKEIT FR EINEN BESTIMMTEN ZWECK. Details finden Sie
~ in der GNU General Public License.
~
~ Sie sollten eine Kopie der GNU General Public License zusammen
~ mit diesem Programm erhalten haben. Falls nicht, schreiben Sie
~ an die Free Software Foundation,
~ Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
**********************************************************************************************/
//require_once("modul.ordner.docunator_class_html.php");

class docgenerate EXTENDS html
{
  //KLASSENVARIABELN
  var $slash;
  var $zielpfad;
  var $doktitel;
  var $grabzeichen;
  var $trennlinie;
  var $maintitel;
  var $filetypes;
  
  /********************************************************************************************
  ~ NAME: function docgenerate()
  ~ ZWECK: Konstruktor
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER:
  ~ BEMERKUNG:
  ********************************************************************************************/
  function docgenerate()
  {
    //KONFIGURATIONSVARIABLEN IMPORTIEREN
    global $ziel;
    global $titel;
    global $grab;
    global $line;
    global $deckblatt;
    global $dateiarten;

    //WERTE DEN KLASSENVARIABLEN ZUWEISEN
    $this->slash = slash_by_os();   //SLASH HOLEN WEGEN SERVERBETRIEBSSYSTEM;
    $this->zielpfad = $ziel;        //ZIEL SETZEN
    $this->doktitel = $titel;       //TITEL DER DOKUMENTATION SETZEN
    $this->maintitel = $deckblatt;  //DECKBLATT DER DOKUMENTATION
    $this->grabzeichen = $grab;     //GRABZEICHEN HOLEN
    $this->trennlinie = $line;       //TRENNLINIE ZWISCHEN DEN DIKUMENTATIONSABSCHNITTEN
    $this->filetypes = $dateiarten;
  }
  
  /********************************************************************************************
  ~ NAME: function generate($datei_array)
  ~ ZWECK: Ausgangsfunktion fr die Generierung der Dokumentation
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER: $datei_array = Array mit den Dateien, die nach DocTags geparst werden sollen
  ~ BEMERKUNG: ausgehend von dieser Funktion wird der gesante Proze der Generierung hier angestoen
  ********************************************************************************************/
  function generate($datei_array)
  {
    //ZU GENERIERENDE DATEIEN AUFBEREITEN
    $dateitypen = explode(";",$this->filetypes);                        //DATEIARTEN AUFSPLITTEN

    //ALLE DATEIEN DURCHLAUFEN, FFNEN, DATEN HOLEN UND DOKUMENTATION GENERIEREN
    if(is_array($datei_array))                              //WENN ARRAY
    {
      $datei_array = $this->dateiarten_extrahieren($datei_array,$dateitypen);   //ZU GENERIERENDE DATEIARTEN EXTRAHIEREN
      $datei_array = $this->sort_dateien($datei_array);                         //ARRAY NACH DATEINAMEN AUFSTEIGEND SORTIEREN

      foreach($datei_array as $val)                         //DURCHLAUFEN
      {
        $content_array = @file($val);                       //INHALT DER DATEI EINLESEN
        $dateiname = $this->dateinamen_extrahieren($val);   //DATEINAMEN AUS PFAD EXTRAHIEREN FR VERLINKUNG IN DER DOKUMENTATION

        //BILDDATEIEN KOPIEREN
        $filetyp = explode(".",$dateiname);

        if($filetyp[1] == "gif" || $filetyp[1] == "GIF" || $filetyp[1] == "jpg" || $filetyp[1] == "JPG" || $filetyp[1] == "png" || $filetyp[1] == "PNG")
        {
          copy($val,$this->zielpfad.$this->slash.$dateiname);
        }

        //INHALT AUFBEREITEN UND FORMATIEREN
        if(is_array($content_array))                        //WENN ARRAY
        { 
          $counter = 0;
          $content_formatiert[$dateiname][] = "<table width=\"100%\" cellspacing=\"1\" cellpadding=\"1\"><tr><td><table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\n";
          
          //LNGE DES GRABZEICHENS ERMITTELN
          $grablen = strlen($this->grabzeichen);
          
          foreach($content_array as $v)                     //INHALT DURCHLAUFEN
          {
            $counter++;
            $v = ltrim($v);                                 //ALLE LEERZEICHNEN LINKS ENTFERNEN                   
            
            //if(substr($v,0,1) == $this->grabzeichen)      //GLTIG NUR FR EINSTELLIGES GRABZEICHEN
            if(substr($v,0,$grablen) == $this->grabzeichen) //AUF GRABZEICHEN UNTERSUCHEN
            {//AUF GRABZEICHEN UNTERSUCHEN
              $content_formatiert[$dateiname][] = $this->parse_line($v);  //ZEILE PARSEN UND WENN DOCTAG, FORMATIERT ZURCKGEBEN
            }
            
            if(substr($v,0,2) == $this->trennlinie)        //AUF LINIENZEICHEN UNTERSUCHEN
            {
              $content_formatiert[$dateiname][] = "</table></td></tr></table><p>\n";
              //$content_formatiert[$dateiname][] = "<br><hr width=\"100%\" size=\"1\" noshade>";  //ZEILE PARSEN UND
              $content_formatiert[$dateiname][] = "<table width=\"100%\" cellspacing=\"1\" cellpadding=\"1\"><tr><td><table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\n";
            }
          }

          $content_formatiert[$dateiname][] = "<tr><th><center><copyright>- Generiert mit dem Docunator am ". date("Y-m-d") ." -</copyright></center></th></tr></table></td></tr></table>\n";
        }
        //NCHSTE DATEI
      }
    }
   
    //FRAMESET GENERIEREN ---------------------------
    $framesetdatei = $this->zielpfad.$this->slash."index.html";
    $framesetfile = @fopen($framesetdatei,"w+");
    @fputs($framesetfile,$this->frameset("index_left.html","index_right.html",$this->doktitel,True));
    @fclose($framesetfile);
    
    //MEN GENERIEREN ---------------------------
    $menudatei = $this->zielpfad.$this->slash."index_left.html";
    $menufile = @fopen($menudatei,"w+");
    @fputs($menufile, $this->header($this->doktitel, True,"core.menu.css"));
    @fputs($menufile,"<a href=\"index_right.html\" target=\"right\">&nbsp;<b>Home</b>&nbsp;</a><p>\n");

    //MEN AUFBAUEN ---------------------------
    foreach($content_formatiert as $key => $val)
    {
      @fputs($menufile,"&nbsp;&nbsp;&nbsp;<a href=\"$key.html\" target=\"right\">&nbsp;$key&nbsp;</a><br>\n");
    }
    
    @fputs($menufile, $this->footer(True));
    @fclose($menufile);

    //"DECKBLATT" GENERIEREN ------------------------
    $hauptdatei = $this->zielpfad.$this->slash."index_right.html";
    $hauptfile = @fopen($hauptdatei,"w+");
    @fputs($hauptfile, $this->header($this->doktitel, True));
    @fputs($hauptfile,$this->maintitel."<p><center><b>Erstelldatum: ".date("Y-m-d")."</b></center>");
    @fputs($hauptfile, $this->footer(True));
    @fclose($hauptfile);

    //DATEIEN ERZEUGEN ---------------------------
    //$key = DATEINAME
    //$val = INHALT DER DATEI ALS ARRAY
    foreach($content_formatiert as $key => $val)
    {
      //PFAD UND DATEI ZUSAMMENBAUEN
      $ausgabedatei = $this->zielpfad.$this->slash.$key.".html";

      //DATEI FFNEN
      $file = @fopen($ausgabedatei,"w+");

      //TITEL UND KOPF SCHREIBEN
      @fputs($file,$this->header($this->doktitel,True));

      //BERSCHRIFT SCHREIBEN
      @fputs($file,"<table width=\"100%\" cellspacing=\"1\" cellpadding=\"1\"><tr><td><table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\n<tr><th><seitentitel>$key</seitentitel></th></tr></table></td></tr></table><p>\n");
      
      //AUF DATEITYP UNTERSUCHEN
      $filetyp = explode(".",$key);
      if($filetyp[1] == "gif" || $filetyp[1] == "GIF" || $filetyp[1] == "jpg" || $filetyp[1] == "JPG" || $filetyp[1] == "png" || $filetyp[1] == "PNG")
      {
        @fputs($file,"<img src=\"$key\"><br>");
      }
      else
      {
        //INHALT SCHREIBEN
        foreach($val as $v)
        {
          @fputs($file,"$v\n");
        }
      }

      //FU SCHREIBEN
      @fputs($file,$this->footer(True));

      //SCHLIESSEN
      @fclose($file);
    }
  }

  /********************************************************************************************
  ~ NAME: function parse_line($content)
  ~ ZWECK: parst den Inhalt einer Zeile und gibt ihn formatiert zurck
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER: $content = Zeile
  ~ BEMERKUNG: damit das funktioniert, mu folgendes Format eingehalten werden
  ~   Tilde-Leerzeichen-DocTag:-Leerzeichen-Beschreibung | Bsp: ~ AUTOR: Andreas Theusner
  ********************************************************************************************/
  function parse_line($content)
  {
    $doctagdatei = getcwd().$this->slash."_config".$this->slash."docunator.doctag.dat"; //PFAD FR DOCTAG-DATEI ZUSAMMENBAUEN
//echo $doctagdatei;
    $doctags = @file($doctagdatei);                                   //DOCTAG-DATEI EINLESEN
    $zerlegt = explode(" ",$content);                                 //BERGEBENE ZEILE ZERLEGEN
                                                                      //FUNKTIONIERT NUR BEI FORMAT: ~ TAG: Inhalt
                                                                      //  ~ AN ANFANG -> LEERZEICHNEN -> DOCTAG: -> LERZEICHEN -> BESCHREIBUNG
//AT-DEBUG
//var_dump($doctags);
//var_dump($zerlegt);
//echo "<br>".$zerlegt[1].count($zerlegt)."<br>";

    //LNGE DES GRABZEICHENS ERMITTELN
    $grablen = strlen($this->grabzeichen);

    //AUF DocTags UNTERSUCHEN UND FORMATIEREN
    if(is_array($doctags))                                            //EINGELESENE DOCTAGS DURCHLAUEFN
    {
      foreach($doctags as $v)
      { 
        if(substr($v,0,1) != "#")                                     //WENN KEIN KOMMENTAR IST
        {
          $val = chop($v);                                            //LEERZEICHEN AM ENDE ENTFERNEN
          $doctagzerlegt = chop($zerlegt[1]);                         //LEERZEICHEN AM ENDE ENTFERNEN
          
          if($doctagzerlegt == $val)                                  //WENN DOCTAGS GEFUNDEN
          { 
            $formatiert = str_replace($doctagzerlegt,"<tr><td align=\"right\" width=\"10%\"><b>$doctagzerlegt</b></td><td>",$content);   //FORMATIEREN UND ...
            $formatiert = substr($formatiert,$grablen)."</td></tr>";                      //ZEILE EINLESEN
            $doctaggefunden = True;                                   //DOCTAG GEFUNDEN
          }
        }
      }

      //WENN KEIN DOCTAG GEFUNDEN
      if($doctaggefunden == False)
      {
         $formatiert = "<tr><td>&nbsp;</td><td>".substr($content,$grablen)."</td></tr>";                             //WENN KEIN DOCTAG GEFUNDEN, ZEILE OHNE FORMATIEREN EINLESEN
      }

//AT-DEBUG
//echo "FORMATIERT: ". $formatiert . count($zerlegt)."<p>";
      return $formatiert;  //RCKGABE
    }
    
// FEST KODIERTE VARIANTE ********************************************************************************
//    switch($zerlegt[1])
//    {
//      case "NAME:"              : $formatiert = str_replace("NAME:","<b>NAME:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "ZWECK:"             : $formatiert = str_replace("ZWECK:","<b>ZWECK:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "AUFRUF:"            : $formatiert = str_replace("AUFRUF:","<b>AUFRUF:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "PARAMETER:"         : $formatiert = str_replace("PARAMETER:","<b>PARAMETER:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "BEMERKUNG:"         : $formatiert = str_replace("BEMERKUNG:","<b>BEMERKUNG:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "PROGRAMM:"          : $formatiert = str_replace("PROGRAMM:","<b>PROGRAMM:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "DATEI:"             : $formatiert = str_replace("DATEI:","<b>DATEI:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "EINBINDUNG:"        : $formatiert = str_replace("EINBINDUNG:","<b>EINBINDUNG:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "ART:"               : $formatiert = str_replace("ART:","<b>ART:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "NAME:"              : $formatiert = str_replace("NAME:","<b>NAME:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "WICHTIG:"           : $formatiert = str_replace("WICHTIG:","<b>WICHTIG:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "HINWEIS:"           : $formatiert = str_replace("HINWEIS:","<b>HINWEIS:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "FUNKTIONSAUFRUF:"   : $formatiert = str_replace("FUNKTIONSAUFRUF:","<b>FUNKTIONSAUFRUF:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "LIZENZ:"            : $formatiert = str_replace("LIZENZ:","<b>LIZENZ:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "ANWENDUNG:"         : $formatiert = str_replace("ANWENDUNG:","<b>ANWENDUNG:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "BESCHREIBUNG:"      : $formatiert = str_replace("BESCHREIBUNG:","<b>BESCHREIBUNG:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;                                  
//      case "AUTOR:"             : $formatiert = str_replace("AUTOR:","<b>AUTOR:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "MAINTAINER:"        : $formatiert = str_replace("MAINTAINER:","<b>MAINTAINER:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "FUNKTION:"          : $formatiert = str_replace("FUNKTION:","<b>FUNKTION:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;
//      case "STATUS:"            : $formatiert = str_replace("STATUS:","<b>STATUS:</b>",$content);
//                                  $formatiert = substr($formatiert,1);
//                                  break;                            
//      default                   : $formatiert = substr($content,1);
//                                  break;
//    }
    //echo "FORMATIERT: $formatiert<br>";
//    return $formatiert;  //RCKGABE
  }
  
  /********************************************************************************************
  ~ NAME: function dateinamen_extrahieren($pfaddatei)
  ~ ZWECK: extrahiert den Dateinamen
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER: $pfaddatei = enthlt den Dateinamen samt kompletten Pfad
  ~ BEMERKUNG: extrahiert fr Verlinkung in der Dokumentation
  ********************************************************************************************/
  function dateinamen_extrahieren($pfaddatei)
  {
    $split = explode($this->slash,$pfaddatei); //ANHAND DER SLASHES SPLITTEN
    $count = count($split);   //ANZAHL DER ARRAYELEMENTE HOLEN
    return $split[$count-1]; //LETZTES ARRAYELEMENT ZURCKGEBEN
  }

  /********************************************************************************************
  ~ NAME: function sort_dateien($array_dateien)
  ~ ZWECK: sortiert ein Array, welches die Dateien samt kompletten Pfad enthlt nur nach
  ~        den Dateinamen, der sich ganz rechts an letzter Stelle befindet und gibt das 
  ~        sortierte Array zurck
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER: $array_dateien = enthlt alle Dateinamen samt kompletten Pfad
  ~ BEMERKUNG: fr aufsteigende Sortierung des Mens
  ********************************************************************************************/
  function sort_dateien($array_dateien)
  {
    $counter = 0;

    if(is_array($array_dateien))                 //WENN ARRAY
    {
      foreach($array_dateien as $val)           //DURCHLAUFEN
      {
        $split = explode($this->slash,$val);    //ANHAND DER SLASHES SPLITTEN
        for($i=count($split)-1;$i>=0;$i--)      //ARRAY VON HINTEN DURCHLAUFEN
        {
        	if($i == 0)                           //ERSTES ARRAYELEMENT OHNE SLASH ...
        	{
        		$puffer .= $split[$i];              //... STRING AUFBAUEN
        	}
        	else
        	{
          	$puffer .= $split[$i] .$this->slash;  //SONST MIT SLASH AUFBAUEN
        	}
        }

        $arr_dateien_neu[] = $puffer;             //IN NEUES ARRAY SCHREIBEN
        unset($puffer);                           //ZERSTREN
      }
    }

		sort($arr_dateien_neu);                       //ARRAY AUFSTEIGEND SORTIEREN

		if(is_array($arr_dateien_neu))                //WENN WIEDERUM ARRAY
    {
      foreach($arr_dateien_neu as $val)           //ERNEUT DURCHLAUFEN
      {
        $split = explode("\\",$val);              //ANHAND DER SLASHES SPLITTEN
        for($i=count($split)-1;$i>=0;$i--)        //WIEDERUM VON HINTEN DURCHLAUFEN -> REVERSE
        {
        	if($i == 0)                             //OHNE SLASH
        	{
        		$puffer .= $split[$i];
        	}
        	else
        	{
          	$puffer .= $split[$i] ."\\";          //SONST MIT SLASH
        	}
        }

        $arr_dateien_sortiert[$counter] = $puffer;        //IN NEUES ARRAY SCHREIBEN
        $counter++;
        unset($puffer);                           //ZERSTREN
      }
    }

    return $arr_dateien_sortiert;                 //SORTIERTES ARRAY ZURCKGEBEN
  }

  /********************************************************************************************
  ~ NAME: function dateiarten_extrahieren($array_dateien,$array_dateiarten)
  ~ ZWECK: extrahiert aus einem Dateiarray die anzeigbaren Dateiarten
  ~        und gibt das so erzeugte Array zurck
  ~ AUFRUF: siehe Dateikopf
  ~ PARAMETER: $array_dateien = enthlt alle Dateinamen samt kompletten Pfad
  ~            $array_dateiarten = enthlt alle anzeigbaren Dateiarten
  ~ BEMERKUNG:
  ********************************************************************************************/
  function dateiarten_extrahieren($array_dateien,$array_dateiarten)
  {
    $count = 0;

    if(is_array($array_dateien) && is_array($array_dateiarten))     //WENN BEIDES ARRAYS SIND
    {
      foreach($array_dateien as $key => $datei)                     //HAUPTSCHLEIFE - DATEIEN
      {
        foreach($array_dateiarten as $art)                          //UNTERSCHLEIFEN - DATEIARTEN
        {
          if(substr($datei,strlen($datei) - strlen($art)) == $art)  //WENN DIE LETZTEN LETZTEN ZEICHEN (DATEIENDUNG) IN DER ARTENLISTE VORHANDEN IST
          {
            $extract_filetype[$count] = $datei;                     //DATEI IN NEUES ARRAY SCHREIBEN
            $count++;                                               //COUNTER HOCHZHLEN
          }
        }
      }
    }

    return $extract_filetype;   //NEUES ARRAY ZURCKGEBEN
  }

//*******************************************************************************************
} //END CLASS
?>
